library(rearrr)
context("flip_values()")


test_that("fuzz testing flipped_values()", {
  xpectr::set_test_seed(42)

  # Create a data frame
  df <- data.frame(
    "x" = runif(15),
    "y" = runif(15),
    "z" = runif(15),
    "i" = 1:15,
    "g" = rep(c(1, 2, 3, 4, 5), each = 3),
    stringsAsFactors = FALSE
  )

  # Generate expectations for 'flip_values'
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = flip_values,
  #   args_values = list(
  #     "data" = list(df, dplyr::group_by(df, g), c(1,2,3,4,5), 1),
  #     "cols" = list(c("x", "y"), c("x", "y", "z"), "x", "", "hej", 1, NA),
  #     "origin" = list(NULL, 0, "hej", NA),
  #     "origin_fn" = list(create_origin_fn(median), create_origin_fn(mean), create_origin_fn(max), median),
  #     "suffix" = list("", "_flipped"),
  #     "keep_original" = list(FALSE, TRUE),
  #     "origin_col_name" = list(".origin", "x", NA),
  #     "overwrite" = list(TRUE, FALSE)
  #   ), extra_combinations = list(
  #     list("data" = 1:5, "cols" = "x"),
  #     list("data" = 1:5, "cols" = NULL, "origin" = c(0, 0), "origin_fn" = NULL),
  #     list("data" = df, "origin_fn" = NULL, origin = c(0.5, 0.1)),
  #     list("data" = "hej", "cols" = NULL),
  #     list("data" = NA, "cols" = NULL),
  #     list("overwrite" = FALSE, "origin_col_name" = "g")
  #   ),
  #   indentation = 2
  # )


  ## Testing 'flip_values'                                                    ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing flip_values(data = df, cols = c("x", "y"), o...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- flip_values(data = df, cols = c("x", "y"), origin = NULL, origin_fn = create_origin_fn(median), suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["x"]],
    c(0.39918, 0.37691, 1.02785, 0.48354, 0.67224, 0.79489, 0.5774,
      1.17932, 0.65699, 0.60892, 0.85624, 0.59487, 0.37931, 1.05856,
      0.85169),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["y"]],
    c(0.18065, 0.14244, 1.00318, 0.64567, 0.56033, 0.21663, 0.98196,
      0.13177, 0.174, 1.03823, 0.60645, 0.73046, 0.21493, 0.6737,
      0.28466),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("x", "y", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("numeric", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("double", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(15L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)

  # Testing flip_values(data = dplyr::group_by(df, g), c...
  # Changed from baseline: data = dplyr::group_b...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19370 <- flip_values(data = dplyr::group_by(df, g), cols = c("x", "y"), origin = NULL, origin_fn = create_origin_fn(median), suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19370),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19370[["g"]],
    c(1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["x"]],
    c(0.91481, 0.89254, 1.54347, 0.45304, 0.64175, 0.7644, 0.5774, 1.17932,
      0.65699, 0.70506, 0.95239, 0.69102, -0.01009, 0.66916, 0.46229),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["y"]],
    c(0.94001, 0.9018, 1.76254, 0.64567, 0.56033, 0.21663, 1.75463,
      0.90444, 0.94667, 0.69797, 0.2662, 0.3902, 0.76627, 1.22504,
      0.836),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19370),
    c("g", "x", "y", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19370),
    c("numeric", "numeric", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19370),
    c("double", "double", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19370),
    c(15L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19370)),
    character(0),
    fixed = TRUE)

  # Testing flip_values(data = c(1, 2, 3, 4, 5), cols = ...
  # Changed from baseline: data = c(1, 2, 3, 4, 5)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12861 <- xpectr::capture_side_effects(flip_values(data = c(1, 2, 3, 4, 5), cols = c("x", "y"), origin = NULL, origin_fn = create_origin_fn(median), suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'data' is not a data.frame, 'col(s)' must be 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing flip_values(data = 1, cols = c("x", "y"), or...
  # Changed from baseline: data = 1
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18304 <- xpectr::capture_side_effects(flip_values(data = 1, cols = c("x", "y"), origin = NULL, origin_fn = create_origin_fn(median), suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'data' is not a data.frame, 'col(s)' must be 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing flip_values(data = NULL, cols = c("x", "y"),...
  # Changed from baseline: data = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16417 <- xpectr::capture_side_effects(flip_values(data = NULL, cols = c("x", "y"), origin = NULL, origin_fn = create_origin_fn(median), suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error']]),
    xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'NULL'\n * checkmate::check_vector(data): Must be of type 'vector', not 'NULL'\n * checkmate::check_factor(data): Must be of type 'factor', not 'NULL'"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing flip_values(data = 1:5, cols = "x", origin =...
  # Changed from baseline: data, cols
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15190 <- xpectr::capture_side_effects(flip_values(data = 1:5, cols = "x", origin = NULL, origin_fn = create_origin_fn(median), suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'data' is not a data.frame, 'col(s)' must be 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing flip_values(data = "hej", cols = NULL, origi...
  # Changed from baseline: data, cols
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17365 <- xpectr::capture_side_effects(flip_values(data = "hej", cols = NULL, origin = NULL, origin_fn = create_origin_fn(median), suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17365[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable ''data' as vector': May only contain the following types: {numeric,factor}, but element 1 has\n * type 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17365[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing flip_values(data = NA, cols = NULL, origin =...
  # Changed from baseline: data, cols
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11346 <- xpectr::capture_side_effects(flip_values(data = NA, cols = NULL, origin = NULL, origin_fn = create_origin_fn(median), suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error']]),
    xpectr::strip(ifelse(
      is_checkmate_v2_1(),
      "Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'logical'\n * checkmate::check_vector(data): Contains missing values (element 1)\n * checkmate::check_factor(data): Must be of type 'factor', not 'logical'",
      "Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'logical'\n * checkmate::check_vector(data): Contains missing values (element 1)\n * checkmate::check_factor(data): Contains missing values (element 1)"
    )),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing flip_values(data = df, cols = c("x", "y"), o...
  # Changed from baseline: data, origin, origin_fn
  xpectr::set_test_seed(42)
  # Assigning output
  output_16569 <- flip_values(data = df, cols = c("x", "y"), origin = c(0.5, 0.1), origin_fn = NULL, suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_16569),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_16569[["x"]],
    c(0.08519, 0.06292, 0.71386, 0.16955, 0.35825, 0.4809, 0.26341,
      0.86533, 0.34301, 0.29494, 0.54226, 0.28089, 0.06533, 0.74457,
      0.53771),
    tolerance = 1e-4)
  expect_equal(
    output_16569[["y"]],
    c(-0.74001, -0.77823, 0.08251, -0.275, -0.36033, -0.70403, 0.06129,
      -0.78889, -0.74667, 0.11756, -0.31421, -0.1902, -0.70574, -0.24697,
      -0.636),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_16569),
    c("x", "y", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_16569),
    c("numeric", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_16569),
    c("double", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_16569),
    c(15L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_16569)),
    character(0),
    fixed = TRUE)

  # Testing flip_values(data = 1:5, cols = NULL, origin ...
  # Changed from baseline: data, cols, origin, o...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17050 <- xpectr::capture_side_effects(flip_values(data = 1:5, cols = NULL, origin = c(0, 0), origin_fn = NULL, suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error']]),
    xpectr::strip("'origin' must have either length 1 or same length as 'cols' (1) but had length 2."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing flip_values(data = df, cols = c("x", "y", "z...
  # Changed from baseline: cols = c("x", "y", "z")
  xpectr::set_test_seed(42)
  # Assigning output
  output_14577 <- flip_values(data = df, cols = c("x", "y", "z"), origin = NULL, origin_fn = create_origin_fn(median), suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_14577),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_14577[["x"]],
    c(0.39918, 0.37691, 1.02785, 0.48354, 0.67224, 0.79489, 0.5774,
      1.17932, 0.65699, 0.60892, 0.85624, 0.59487, 0.37931, 1.05856,
      0.85169),
    tolerance = 1e-4)
  expect_equal(
    output_14577[["y"]],
    c(0.18065, 0.14244, 1.00318, 0.64567, 0.56033, 0.21663, 0.98196,
      0.13177, 0.174, 1.03823, 0.60645, 0.73046, 0.21493, 0.6737,
      0.28466),
    tolerance = 1e-4)
  expect_equal(
    output_14577[["z"]],
    c(0.13395, 0.06049, 0.48343, 0.18637, 0.86759, 0.03863, 0.86421,
      0.66388, -0.03506, 0.25976, 0.49198, 0.43577, 0.83411, -0.102,
      0.43979),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_14577),
    c("x", "y", "z", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_14577),
    c("numeric", "numeric", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_14577),
    c("double", "double", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14577),
    c(15L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_14577)),
    character(0),
    fixed = TRUE)

  # Testing flip_values(data = df, cols = "x", origin = ...
  # Changed from baseline: cols = "x"
  xpectr::set_test_seed(42)
  # Assigning output
  output_17191 <- flip_values(data = df, cols = "x", origin = NULL, origin_fn = create_origin_fn(median), suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_17191),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17191[["x"]],
    c(0.39918, 0.37691, 1.02785, 0.48354, 0.67224, 0.79489, 0.5774,
      1.17932, 0.65699, 0.60892, 0.85624, 0.59487, 0.37931, 1.05856,
      0.85169),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_17191),
    c("x", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17191),
    c("numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17191),
    c("double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17191),
    c(15L, 2L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17191)),
    character(0),
    fixed = TRUE)

  # Testing flip_values(data = df, cols = "", origin = N...
  # Changed from baseline: cols = ""
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19346 <- xpectr::capture_side_effects(flip_values(data = df, cols = "", origin = NULL, origin_fn = create_origin_fn(median), suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_match(
    xpectr::strip(side_effects_19346[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'cols': All elements must have at least 1 characters"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing flip_values(data = df, cols = "hej", origin ...
  # Changed from baseline: cols = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12554 <- xpectr::capture_side_effects(flip_values(data = df, cols = "hej", origin = NULL, origin_fn = create_origin_fn(median), suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error']]),
    xpectr::strip("1 assertions failed:\n * These names in the 'col(s)' argument were not found in 'data': hej."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing flip_values(data = df, cols = 1, origin = NU...
  # Changed from baseline: cols = 1
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14622 <- xpectr::capture_side_effects(flip_values(data = df, cols = 1, origin = NULL, origin_fn = create_origin_fn(median), suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14622[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'cols': Must be of type 'character', not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14622[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing flip_values(data = df, cols = NA, origin = N...
  # Changed from baseline: cols = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19400 <- xpectr::capture_side_effects(flip_values(data = df, cols = NA, origin = NULL, origin_fn = create_origin_fn(median), suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error']]),
    xpectr::strip("Assertion on 'specified column names (NA, \".origin\")' failed: Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing flip_values(data = df, cols = NULL, origin =...
  # Changed from baseline: cols = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19782 <- xpectr::capture_side_effects(flip_values(data = df, cols = NULL, origin = NULL, origin_fn = create_origin_fn(median), suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error']]),
    xpectr::strip("When 'data' is a data.frame, 'cols' must be specified."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing flip_values(data = df, cols = c("x", "y"), o...
  # Changed from baseline: origin = 0
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11174 <- xpectr::capture_side_effects(flip_values(data = df, cols = c("x", "y"), origin = 0, origin_fn = create_origin_fn(median), suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11174[['warnings']]),
    xpectr::strip(character(0)),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11174[['messages']]),
    xpectr::strip("When 'origin_fn' is specified, 'origin' is ignored.\n"),
    fixed = TRUE)
  # Assigning output
  output_11174 <- xpectr::suppress_mw(flip_values(data = df, cols = c("x", "y"), origin = 0, origin_fn = create_origin_fn(median), suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE))
  # Testing class
  expect_equal(
    class(output_11174),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_11174[["x"]],
    c(0.39918, 0.37691, 1.02785, 0.48354, 0.67224, 0.79489, 0.5774,
      1.17932, 0.65699, 0.60892, 0.85624, 0.59487, 0.37931, 1.05856,
      0.85169),
    tolerance = 1e-4)
  expect_equal(
    output_11174[["y"]],
    c(0.18065, 0.14244, 1.00318, 0.64567, 0.56033, 0.21663, 0.98196,
      0.13177, 0.174, 1.03823, 0.60645, 0.73046, 0.21493, 0.6737,
      0.28466),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_11174),
    c("x", "y", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_11174),
    c("numeric", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_11174),
    c("double", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_11174),
    c(15L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_11174)),
    character(0),
    fixed = TRUE)

  # Testing flip_values(data = df, cols = c("x", "y"), o...
  # Changed from baseline: origin = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14749 <- xpectr::capture_side_effects(flip_values(data = df, cols = c("x", "y"), origin = "hej", origin_fn = create_origin_fn(median), suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14749[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'origin': Must be of type 'numeric' (or 'NULL'), not 'character'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14749[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing flip_values(data = df, cols = c("x", "y"), o...
  # Changed from baseline: origin = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15603 <- xpectr::capture_side_effects(flip_values(data = df, cols = c("x", "y"), origin = NA, origin_fn = create_origin_fn(median), suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15603[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'origin': Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15603[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing flip_values(data = df, cols = c("x", "y"), o...
  # Changed from baseline: origin_fn = create_or...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19040 <- flip_values(data = df, cols = c("x", "y"), origin = NULL, origin_fn = create_origin_fn(mean), suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19040),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19040[["x"]],
    c(0.31078, 0.28851, 0.93944, 0.39514, 0.58384, 0.70649, 0.48899,
      1.09092, 0.56859, 0.52052, 0.76784, 0.50647, 0.29091, 0.97015,
      0.76329),
    tolerance = 1e-4)
  expect_equal(
    output_19040[["y"]],
    c(0.28998, 0.25176, 1.1125, 0.75499, 0.66966, 0.32596, 1.09128,
      0.2411, 0.28332, 1.14755, 0.71578, 0.83979, 0.32425, 0.78302,
      0.39399),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19040),
    c("x", "y", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19040),
    c("numeric", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19040),
    c("double", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19040),
    c(15L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19040)),
    character(0),
    fixed = TRUE)

  # Testing flip_values(data = df, cols = c("x", "y"), o...
  # Changed from baseline: origin_fn = create_or...
  xpectr::set_test_seed(42)
  # Assigning output
  output_11387 <- flip_values(data = df, cols = c("x", "y"), origin = NULL, origin_fn = create_origin_fn(max), suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_11387),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_11387[["x"]],
    c(0.95934, 0.93708, 1.58801, 1.0437, 1.23241, 1.35505, 1.13756,
      1.73948, 1.21716, 1.16909, 1.41641, 1.15504, 0.93948, 1.61872,
      1.41186),
    tolerance = 1e-4)
  expect_equal(
    output_11387[["y"]],
    c(1.03777, 0.99956, 1.8603, 1.50279, 1.41745, 1.07375, 1.83907,
      0.98889, 1.03112, 1.89535, 1.46357, 1.58758, 1.07205, 1.53081,
      1.14178),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_11387),
    c("x", "y", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_11387),
    c("numeric", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_11387),
    c("double", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_11387),
    c(15L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_11387)),
    character(0),
    fixed = TRUE)

  # Testing flip_values(data = df, cols = c("x", "y"), o...
  # Changed from baseline: origin_fn = median
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19888 <- xpectr::capture_side_effects(flip_values(data = df, cols = c("x", "y"), origin = NULL, origin_fn = median, suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19888[['error']]),
    xpectr::strip("output of 'origin_fn' must have same length as 'cols' (2) but had length 1."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19888[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing flip_values(data = df, cols = c("x", "y"), o...
  # Changed from baseline: origin_fn = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19466 <- xpectr::capture_side_effects(flip_values(data = df, cols = c("x", "y"), origin = NULL, origin_fn = NULL, suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19466[['error']]),
    xpectr::strip("1 assertions failed:\n * At least one of {'origin', 'origin_fn'} must be specified (not 'NULL')."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19466[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing flip_values(data = df, cols = c("x", "y"), o...
  # Changed from baseline: suffix = "_flipped"
  xpectr::set_test_seed(42)
  # Assigning output
  output_10824 <- flip_values(data = df, cols = c("x", "y"), origin = NULL, origin_fn = create_origin_fn(median), suffix = "_flipped", keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_10824),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_10824[["x_flipped"]],
    c(0.39918, 0.37691, 1.02785, 0.48354, 0.67224, 0.79489, 0.5774,
      1.17932, 0.65699, 0.60892, 0.85624, 0.59487, 0.37931, 1.05856,
      0.85169),
    tolerance = 1e-4)
  expect_equal(
    output_10824[["y_flipped"]],
    c(0.18065, 0.14244, 1.00318, 0.64567, 0.56033, 0.21663, 0.98196,
      0.13177, 0.174, 1.03823, 0.60645, 0.73046, 0.21493, 0.6737,
      0.28466),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_10824),
    c("x_flipped", "y_flipped", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_10824),
    c("numeric", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_10824),
    c("double", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_10824),
    c(15L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_10824)),
    character(0),
    fixed = TRUE)

  # Testing flip_values(data = df, cols = c("x", "y"), o...
  # Changed from baseline: suffix = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15142 <- xpectr::capture_side_effects(flip_values(data = df, cols = c("x", "y"), origin = NULL, origin_fn = create_origin_fn(median), suffix = NULL, keep_original = FALSE, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15142[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'suffix': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15142[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing flip_values(data = df, cols = c("x", "y"), o...
  # Changed from baseline: keep_original = TRUE
  xpectr::set_test_seed(42)
  # Assigning output
  output_13902 <- flip_values(data = df, cols = c("x", "y"), origin = NULL, origin_fn = create_origin_fn(median), suffix = "", keep_original = TRUE, origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_13902),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_13902[["z"]],
    c(0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292, 0.00733,
      0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743, 0.97354,
      0.43175),
    tolerance = 1e-4)
  expect_equal(
    output_13902[["i"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15),
    tolerance = 1e-4)
  expect_equal(
    output_13902[["g"]],
    c(1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5),
    tolerance = 1e-4)
  expect_equal(
    output_13902[["x"]],
    c(0.39918, 0.37691, 1.02785, 0.48354, 0.67224, 0.79489, 0.5774,
      1.17932, 0.65699, 0.60892, 0.85624, 0.59487, 0.37931, 1.05856,
      0.85169),
    tolerance = 1e-4)
  expect_equal(
    output_13902[["y"]],
    c(0.18065, 0.14244, 1.00318, 0.64567, 0.56033, 0.21663, 0.98196,
      0.13177, 0.174, 1.03823, 0.60645, 0.73046, 0.21493, 0.6737,
      0.28466),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_13902),
    c("z", "i", "g", "x", "y", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_13902),
    c("numeric", "integer", "numeric", "numeric", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_13902),
    c("double", "integer", "double", "double", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_13902),
    c(15L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_13902)),
    character(0),
    fixed = TRUE)

  # Testing flip_values(data = df, cols = c("x", "y"), o...
  # Changed from baseline: keep_original = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19057 <- xpectr::capture_side_effects(flip_values(data = df, cols = c("x", "y"), origin = NULL, origin_fn = create_origin_fn(median), suffix = "", keep_original = NULL, origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19057[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'keep_original': Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19057[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing flip_values(data = df, cols = c("x", "y"), o...
  # Changed from baseline: origin_col_name = "x"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14469 <- xpectr::capture_side_effects(flip_values(data = df, cols = c("x", "y"), origin = NULL, origin_fn = create_origin_fn(median), suffix = "", keep_original = FALSE, origin_col_name = "x", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14469[['error']]),
    xpectr::strip("Assertion on 'specified column names (\"x\", \"y\", \"x\")' failed: Contains duplicated values, position 3."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14469[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing flip_values(data = df, cols = c("x", "y"), o...
  # Changed from baseline: origin_col_name = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18360 <- xpectr::capture_side_effects(flip_values(data = df, cols = c("x", "y"), origin = NULL, origin_fn = create_origin_fn(median), suffix = "", keep_original = FALSE, origin_col_name = NA, overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18360[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'origin_col_name': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18360[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing flip_values(data = df, cols = c("x", "y"), o...
  # Changed from baseline: origin_col_name = NULL
  xpectr::set_test_seed(42)
  # Assigning output
  output_17375 <- flip_values(data = df, cols = c("x", "y"), origin = NULL, origin_fn = create_origin_fn(median), suffix = "", keep_original = FALSE, origin_col_name = NULL, overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_17375),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17375[["x"]],
    c(0.39918, 0.37691, 1.02785, 0.48354, 0.67224, 0.79489, 0.5774,
      1.17932, 0.65699, 0.60892, 0.85624, 0.59487, 0.37931, 1.05856,
      0.85169),
    tolerance = 1e-4)
  expect_equal(
    output_17375[["y"]],
    c(0.18065, 0.14244, 1.00318, 0.64567, 0.56033, 0.21663, 0.98196,
      0.13177, 0.174, 1.03823, 0.60645, 0.73046, 0.21493, 0.6737,
      0.28466),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_17375),
    c("x", "y"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17375),
    c("numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17375),
    c("double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17375),
    c(15L, 2L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17375)),
    character(0),
    fixed = TRUE)

  # Testing flip_values(data = df, cols = c("x", "y"), o...
  # Changed from baseline: origin_col_name, over...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18110 <- xpectr::capture_side_effects(flip_values(data = df, cols = c("x", "y"), origin = NULL, origin_fn = create_origin_fn(median), suffix = "", keep_original = FALSE, origin_col_name = "g", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18110[['error']]),
    xpectr::strip("1 assertions failed:\n * The column 'g' already exists and 'overwrite' is disabled."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18110[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing flip_values(data = df, cols = c("x", "y"), o...
  # Changed from baseline: overwrite = FALSE
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_13881 <- xpectr::capture_side_effects(flip_values(data = df, cols = c("x", "y"), origin = NULL, origin_fn = create_origin_fn(median), suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13881[['error']]),
    xpectr::strip("Adding these dimensions would overwrite existing columns: x, y."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13881[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing flip_values(data = df, cols = c("x", "y"), o...
  # Changed from baseline: overwrite = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16851 <- xpectr::capture_side_effects(flip_values(data = df, cols = c("x", "y"), origin = NULL, origin_fn = create_origin_fn(median), suffix = "", keep_original = FALSE, origin_col_name = ".origin", overwrite = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16851[['error']]),
    xpectr::strip("Assertion on 'overwrite' failed: Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16851[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'flip_values'                                           ####
  #


  ## Testing 'df'                                                           ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(df),
    "data.frame",
    fixed = TRUE)
  # Testing column values
  expect_equal(
    df[["x"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229),
    tolerance = 1e-4)
  expect_equal(
    df[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    df[["z"]],
    c(0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292, 0.00733,
      0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743, 0.97354,
      0.43175),
    tolerance = 1e-4)
  expect_equal(
    df[["i"]],
    c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15),
    tolerance = 1e-4)
  expect_equal(
    df[["g"]],
    c(1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(df),
    c("x", "y", "z", "i", "g"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(df),
    c("numeric", "numeric", "numeric", "integer", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(df),
    c("double", "double", "double", "integer", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(df),
    c(15L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(df)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'df'                                                  ####


})

test_that("testing flip_values_vec()", {
  xpectr::set_test_seed(42)


  ## Testing 'flip_values_vec(runif(10), origin = 0.3, ori...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_14577 <- flip_values_vec(runif(10), origin = 0.3, origin_fn = NULL)
  # Testing class
  expect_equal(
    class(output_14577),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_14577,
    type = "double")
  # Testing values
  expect_equal(
    output_14577,
    c(-0.31481, -0.33708, 0.31386, -0.23045, -0.04175, 0.0809, -0.13659,
      0.46533, -0.05699, -0.10506),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_14577),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_14577),
    10L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_14577)),
    10L)
  ## Finished testing 'flip_values_vec(runif(10), origin = 0.3, ori...'     ####



  ## Testing 'flip_values_vec(runif(10), origin = NULL, or...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_19370 <- flip_values_vec(runif(10), origin = NULL, origin_fn = centroid)
  # Testing class
  expect_equal(
    class(output_19370),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19370,
    type = "double")
  # Testing values
  expect_equal(
    output_19370,
    c(0.35772, 0.33545, 0.98638, 0.44208, 0.63078, 0.75343, 0.53594,
      1.13786, 0.61553, 0.56746),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_19370),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19370),
    10L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19370)),
    10L)
  ## Finished testing 'flip_values_vec(runif(10), origin = NULL, or...'     ####





  ## Testing 'flip_values_vec(runif(10), origin = 0, origi...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19148 <- xpectr::capture_side_effects(flip_values_vec(runif(10), origin = 0, origin_fn = centroid), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['warnings']]),
    xpectr::strip(character(0)),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['messages']]),
    xpectr::strip("When 'origin_fn' is specified, 'origin' is ignored.\n"),
    fixed = TRUE)
  # Assigning output
  output_19148 <- xpectr::suppress_mw(flip_values_vec(runif(10), origin = 0, origin_fn = centroid))
  # Testing class
  expect_equal(
    class(output_19148),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "double")
  # Testing values
  expect_equal(
    output_19148,
    c(0.35772, 0.33545, 0.98638, 0.44208, 0.63078, 0.75343, 0.53594,
      1.13786, 0.61553, 0.56746),
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_19148),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    10L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    10L)
  ## Finished testing 'flip_values_vec(runif(10), origin = 0, origi...'     ####

})

