% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bibtex.R
\name{split_bibtex_references}
\alias{split_bibtex_references}
\title{split BibTex references}
\usage{
split_bibtex_references(bib_path)
}
\arguments{
\item{bib_path}{path to the bibtex file to be read}
}
\value{
list of references separated as types and names based on indices
}
\description{
split BibTex references
}
\examples{
dir.create(your_article_folder <- file.path(tempdir(), "exampledir"))
example_files <-  system.file("article", package = "rebib")
x <- file.copy(from = example_files,to=your_article_folder,recursive = TRUE)
your_article_path <- paste(your_article_folder,"article",sep="/")
bib_path <- paste0(your_article_path,"/example.bib")
rebib::handle_bibliography(your_article_path)
references <- rebib::split_bibtex_references(bib_path)
references
unlink(your_article_folder,recursive = TRUE)
}
