% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_CD_local.R
\name{gg_CD_local}
\alias{gg_CD_local}
\title{Plots Cumulative Distributions of PIT-values for local calibration diagnose.}
\usage{
gg_CD_local(
  pit_local,
  psz = 0.01,
  abline = "black",
  pal = "Set2",
  facet = FALSE,
  ...
)
}
\arguments{
\item{pit_local}{A data frame obtained from PIT_local_lm}

\item{psz}{double that indicates size of the points that compose the lines.
Default is 0.001}

\item{abline}{Color of horizontal line that indicates density 1. Default is"red"}

\item{pal}{Palette name from RColorBrewer. Default is "Set2'}

\item{facet}{logical value in case separate visualization is preferred. Default is F}

\item{...}{Other parameters to pass ggplot}
}
\value{
a ggplot graph
}
\description{
ggplot to visualize predicted vs empirical cumulative distributions of PIT-values locally
}
\examples{

n <- 10000
split <- 0.8

mu <- function(x1){
10 + 5*x1^2
}

sigma_v <- function(x1){
30*x1
}


x <- runif(n, 1, 10)
y <- rnorm(n, mu(x), sigma_v(x))

x_train <- x[1:(n*split)]
y_train <- y[1:(n*split)]

x_cal <- x[(n*split+1):n]
y_cal <- y[(n*split+1):n]

model <- lm(y_train ~ x_train)

y_hat <- predict(model, newdata=data.frame(x_train=x_cal))

MSE_cal <- mean((y_hat - y_cal)^2)

pit_local <- PIT_local(xcal = x_cal, ycal=y_cal, yhat=y_hat, mse=MSE_cal)

gg_CD_local(pit_local)
gg_CD_local(pit_local, facet=TRUE)

}
