% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdraws_rpvals.R
\name{pChapman}
\alias{pChapman}
\title{Hypothesis Testing Using the Chapman Estimator}
\usage{
pChapman(
  estN = NULL,
  nullN,
  n1,
  n2,
  m2 = NULL,
  nsim = 1e+05,
  alternative = "less"
)
}
\arguments{
\item{estN}{The estimated abundance.  Either this or the number of recaptures
(\code{m2}) must be specified.}

\item{nullN}{The abundance given by the null hypothesis}

\item{n1}{Number of individuals captured and marked in the first sample}

\item{n2}{Number of individuals captured in the second sample}

\item{m2}{Number of recaptures.  Either this or the estimated abundance
(\code{estN}) must be specified.}

\item{nsim}{Number of simulated values to draw.  Defaults to 100000.}

\item{alternative}{Direction of the alternative hypothesis.  Allowed values
are \code{"less"}, \code{"greater"}, or \code{"2-sided"}.  Defaults to \code{"less"}.}
}
\value{
An approximate p-value for the specified hypothesis test.  If
  \code{m2} is specified rather than \code{estN}, output will be returned as
  a list with two elements: the estimated abundance and p-value.
}
\description{
Approximates a p-value for a hypothesis test of the Chapman
  estimator by means of many simulated draws from the null distribution, conditioned on sample sizes.
}
\note{
Any Petersen-type estimator (such as this) depends on a set of
  assumptions: \itemize{ \item  The population is closed; that is, that there
  are no births, deaths, immigration, or emigration between sampling events
  \item All individuals have the same probability of capture in one of the
  two events, or complete mixing occurs between events \item Marking in the
  first event does not affect probability of recapture in the second event
  \item Individuals do not lose marks between events \item All marks will be
  reported in the second event }
}
\examples{
output <- pChapman(nullN=500, n1=100, n2=100, m2=28)
output

plotdiscdensity(rChapman(length=100000, N=500, n1=100, n2=100))
abline(v=output$estN, lwd=2, col=2)
abline(v=500, lwd=2, lty=2)


output <- pChapman(nullN=500, n1=100, n2=100, m2=28, alternative="2-sided")
output

plotdiscdensity(rChapman(length=100000, N=500, n1=100, n2=100))
twosided <- 500 + c(-1,1)*abs(500-output$estN)
abline(v=twosided, lwd=2, col=2)
abline(v=500, lwd=2, lty=2)
}
\seealso{
\link{NChapman}, \link{vChapman}, \link{seChapman}, \link{rChapman},
  \link{powChapman}, \link{ciChapman}
}
\author{
Matt Tyers
}
