% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kpca_rbf.R
\name{step_kpca_rbf}
\alias{step_kpca_rbf}
\title{Radial basis function kernel PCA signal extraction}
\usage{
step_kpca_rbf(
  recipe,
  ...,
  role = "predictor",
  trained = FALSE,
  num_comp = 5,
  res = NULL,
  columns = NULL,
  sigma = 0.2,
  prefix = "kPC",
  keep_original_cols = FALSE,
  skip = FALSE,
  id = rand_id("kpca_rbf")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of
operations for this recipe.}

\item{...}{One or more selector functions to choose variables for this step.
See \code{\link[=selections]{selections()}} for more details.}

\item{role}{For model terms created by this step, what analysis role should
they be assigned? By default, the new columns created by this step from the
original variables will be used as \emph{predictors} in a model.}

\item{trained}{A logical to indicate if the quantities for preprocessing have
been estimated.}

\item{num_comp}{The number of components to retain as new predictors. If
\code{num_comp} is greater than the number of columns or the number of possible
components, a smaller value will be used. If \code{num_comp = 0} is set then no
transformation is done and selected variables will stay unchanged,
regardless of the value of \code{keep_original_cols}.}

\item{res}{An S4 \code{\link[kernlab:kpca]{kernlab::kpca()}} object is stored here once this
preprocessing step has be trained by \code{\link[=prep]{prep()}}.}

\item{columns}{A character string of the selected variable names. This field
is a placeholder and will be populated once \code{\link[=prep]{prep()}} is used.}

\item{sigma}{A numeric value for the radial basis function parameter. See the
documentation at \code{\link[kernlab:dots]{kernlab::rbfdot()}}.}

\item{prefix}{A character string for the prefix of the resulting new
variables. See notes below.}

\item{keep_original_cols}{A logical to keep the original variables in the
output. Defaults to \code{FALSE}.}

\item{skip}{A logical. Should the step be skipped when the recipe is baked by
\code{\link[=bake]{bake()}}? While all operations are baked when \code{\link[=prep]{prep()}} is run, some
operations may not be able to be conducted on new data (e.g. processing the
outcome variable(s)). Care should be taken when using \code{skip = TRUE} as it
may affect the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_kpca_rbf()} creates a \emph{specification} of a recipe step that will
convert numeric data into one or more principal components using a radial
basis function kernel basis expansion.
}
\details{
Kernel principal component analysis (kPCA) is an extension of a PCA analysis
that conducts the calculations in a broader dimensionality defined by a
kernel function. For example, if a quadratic kernel function were used,
each variable would be represented by its original values as well as its
square. This nonlinear mapping is used during the PCA analysis and can
potentially help find better representations of the original data.

This step requires the \pkg{kernlab} package.
If not installed, the step will stop with a prompt about installing
the package.

As with ordinary PCA, it is important to center and scale the variables
prior to computing PCA components (\code{\link[=step_normalize]{step_normalize()}} can be used for
this purpose).

The argument \code{num_comp} controls the number of components that will be retained
(the original variables that are used to derive the components are removed from
the data). The new components will have names that begin with \code{prefix} and a
sequence of numbers. The variable names are padded with zeros. For example, if
\code{num_comp < 10}, their names will be \code{kPC1} - \code{kPC9}. If \code{num_comp = 101},
the names would be \code{kPC1} - \code{kPC101}.
}
\section{tidy() results}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble with column
\code{terms} (the selectors or variables selected) is returned.
}

\section{Tuning Parameters}{
This step has 2 tuning parameters:
\itemize{
\item \code{num_comp}: # Components (type: integer, default: 5)
\item \code{sigma}: Radial Basis Function sigma (type: double, default: 0.2)
}
}

\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble is returned with
columns \code{terms} and \code{id}:

\describe{
\item{terms}{character, the selectors or variables selected}
\item{id}{character, id of this step}
}
}

\section{Case weights}{


The underlying operation does not allow for case weights.
}

\examples{
\dontshow{if (rlang::is_installed(c("modeldata", "ggplot2", "kernlab"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(ggplot2)
data(biomass, package = "modeldata")

biomass_tr <- biomass[biomass$dataset == "Training", ]
biomass_te <- biomass[biomass$dataset == "Testing", ]

rec <- recipe(
  HHV ~ carbon + hydrogen + oxygen + nitrogen + sulfur,
  data = biomass_tr
)

kpca_trans <- rec \%>\%
  step_YeoJohnson(all_numeric_predictors()) \%>\%
  step_normalize(all_numeric_predictors()) \%>\%
  step_kpca_rbf(all_numeric_predictors())

kpca_estimates <- prep(kpca_trans, training = biomass_tr)

kpca_te <- bake(kpca_estimates, biomass_te)

ggplot(kpca_te, aes(x = kPC1, y = kPC2)) +
  geom_point() +
  coord_equal()

tidy(kpca_trans, number = 3)
tidy(kpca_estimates, number = 3)
\dontshow{\}) # examplesIf}
}
\references{
Scholkopf, B., Smola, A., and Muller, K. (1997).
Kernel principal component analysis. \emph{Lecture Notes in
Computer Science}, 1327, 583-588.

Karatzoglou, K., Smola, A., Hornik, K., and Zeileis, A. (2004).
kernlab - An S4 package for kernel methods in R. \emph{Journal
of Statistical Software}, 11(1), 1-20.
}
\seealso{
Other multivariate transformation steps: 
\code{\link{step_classdist}()},
\code{\link{step_classdist_shrunken}()},
\code{\link{step_depth}()},
\code{\link{step_geodist}()},
\code{\link{step_ica}()},
\code{\link{step_isomap}()},
\code{\link{step_kpca}()},
\code{\link{step_kpca_poly}()},
\code{\link{step_mutate_at}()},
\code{\link{step_nnmf}()},
\code{\link{step_nnmf_sparse}()},
\code{\link{step_pca}()},
\code{\link{step_pls}()},
\code{\link{step_ratio}()},
\code{\link{step_spatialsign}()}
}
\concept{multivariate transformation steps}
