% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_problink.R
\name{score_problink}
\alias{score_problink}
\title{Score comparison patterns of pairs using the probabilistic linkage framework}
\usage{
score_problink(pairs, model = NULL, var = "weight", add = TRUE, ...)
}
\arguments{
\item{pairs}{a \code{pairs} object, such as generated by 
\code{\link{pair_blocking}}}

\item{model}{an object of type \code{\link{problink_em}} containing the 
estimated m- and u-probabilities. When \code{NULL} or missing a model is
estimated.}

\item{var}{the name of the new variable that will be created (also see
details).}

\item{add}{add the estimated score to the \code{pairs} object and return the
pairs object. Otherwise, just the scores are returned.}

\item{...}{passed on to \code{\link{predict.problink_em}}.}
}
\value{
When \code{add = TRUE}, the pairs object is returned with the scores added 
to it. The new column will have the name \code{var} unless additional 
arguments are passed on to \code{\link{predict.problink_em}} using the 
\code{...} argument that causes the calculation of multiple scores (such
are \code{type = "all"}). In that case the text given by \code{var} is 
prepended to the names of the variables returned by 
\code{\link{predict.problink_em}} (with a separator '\code{_}'). 

When \code{add = FALSE} the scores are returned as is.
}
\description{
Score comparison patterns of pairs using the probabilistic linkage framework
}
\examples{
data("linkexample1", "linkexample2")
pairs <- pair_blocking(linkexample1, linkexample2, "postcode")
pairs <- compare_pairs(pairs, c("lastname", "firstname", "address", "sex"))
pairs <- score_problink(pairs)

# is the same as
model <- problink_em(pairs)
pairs <- score_problink(pairs, model = model)

\dontshow{gc()}

}
