% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_compare_vars.R, R/compare_vars.R
\name{compare_vars.cluster_pairs}
\alias{compare_vars.cluster_pairs}
\alias{compare_vars}
\alias{compare_vars.pairs}
\title{Compare pairs on given variables}
\usage{
\method{compare_vars}{cluster_pairs}(
  pairs,
  variable,
  on_x = variable,
  on_y = on_x,
  comparator = identical(),
  new_name = NULL,
  ...
)

compare_vars(
  pairs,
  variable,
  on_x = variable,
  on_y = on_x,
  comparator = identical(),
  ...
)

\method{compare_vars}{pairs}(
  pairs,
  variable,
  on_x = variable,
  on_y = on_x,
  comparator = identical(),
  x = attr(pairs, "x"),
  y = attr(pairs, "y"),
  inplace = FALSE,
  ...
)
}
\arguments{
\item{pairs}{\code{\link{data.table}} with pairs. Should contain the columns 
\code{.x} and \code{.y}.}

\item{variable}{character vector with name of resulting column name that is added
to pairs.}

\item{on_x}{character vector with the column names from \code{x} on which to 
compare.}

\item{on_y}{character vector with the column names from \code{y} on which to 
compare.}

\item{comparator}{function with which the variables are compared. When \code{on_x} and 
\code{on_y} have length 1, this function should accept two vectors. Otherwise
it will receive two \code{data.tables}. Function should either return a vector
or a \code{data.table} with multiple columns.}

\item{new_name}{name of new object to assign the pairs to on the cluster
nodes.}

\item{...}{Used to pass additional arguments to methods}

\item{x}{\code{data.table} with one half of the pairs.}

\item{y}{\code{data.table} with the other half of the pairs.}

\item{inplace}{logical indicating whether \code{pairs} should be modified in place. When
pairs is large this can be more efficient.}
}
\value{
Returns the \code{data.table} \code{pairs} with one or more columns added.
}
\description{
Compare pairs on given variables
}
\details{
When \code{comparator} returns a \code{data.table} multiple columns are added to \code{pairs}. 
The names of these columns are \code{variable} pasted together with the names of 
the \code{data.table} returned by \code{comparator} (separated by "_").
}
