% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_call.R
\name{cluster_call}
\alias{cluster_call}
\title{Call a function on each of the worker nodes and pass it the pairs}
\usage{
cluster_call(pairs, fun, ...)
}
\arguments{
\item{pairs}{an object or type \code{cluster_pairs} as created for example by
\code{\link{cluster_pair}}.}

\item{fun}{a function to call on each of the worker nodes. See details on the
arguments of this function.}

\item{...}{additional arguments are passed on to \code{fun}.}
}
\value{
The function will return a list with for each worker the result of the
function call. When the functions return \code{NULL} the result is returned
invisibly. Because the result is returned to main node, make sure you don't
accidentally return all pairs. If you don't want to return anything end your
function with \code{NULL}.
}
\description{
Call a function on each of the worker nodes and pass it the pairs
}
\details{
The function will have to accept the following arguments as its first three
arguments:

\describe{
  \item{pairs}{the \code{data.table} with the pairs of the worker node.}
  \item{x}{a \code{data.table} with the portion of \code{x} present on the 
    worker node.}
  \item{y}{a \code{data.table} with \code{y}.}
}
}
\examples{
# Generate some pairs
library(parallel)
data("linkexample1", "linkexample2")
cl <- makeCluster(2)
\dontshow{clusterEvalQ(cl, data.table::setDTthreads(1))}
pairs <- cluster_pair(cl, linkexample1, linkexample2)
compare_pairs(pairs, c("lastname", "firstname", "address", "sex"))

# Add a new column to pairs
cluster_call(pairs, function(pairs, ...) {
  pairs[, name := firstname & lastname]
  # we don't want to return the pairs; so make sure to return something
  # else
  NULL
})

# Get the number of pairs on each node
lenghts <- cluster_call(pairs, function(pairs, ...) {
  nrow(pairs)
})
lengths <- unlist(lenghts)
lenghts

# Cleanup
stopCluster(cl)

}
