% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/red.R
\name{map.easy}
\alias{map.easy}
\title{Predict species distribution made simple.}
\usage{
map.easy(longlat, layers = NULL, file = NULL, minimum = 3, jack = 0)
}
\arguments{
\item{longlat}{Matrix of longitude and latitude (two columns) of each occurrence record.}

\item{layers}{Raster* object as defined by package raster. If NULL they are read from data files.}

\item{file}{Name of output csv file with all results. If NULL it is named "Results_All.csv".}

\item{minimum}{Minimum number of occurrence records to perform a maxent model. If these are lower than the minimum, the function will return a map with presences points only.}

\item{jack}{If 0 no jackknife is performed. If 1, a jackknife with number of runs equivalent to the number of records is made. If > 1 these are the number of runs. For each run one random record is left out at a time and a new set of 1000 background points is chosen.}
}
\value{
Writes maps, kmls and all information to a file.
}
\description{
Prediction of species distributions, multiple species simultaneously, and output of maps, klms and relevant data to files. All using a single step.
}
\details{
Builds maxent species distribution models and outputs maps in both pdf and kml format, plus a file with EOO, AOO and a list of countries where the species is predicted to be present.
}

