% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/red.R
\name{raster.distance}
\alias{raster.distance}
\title{Create distance layer.}
\usage{
raster.distance(longlat, layers, type = "minimum")
}
\arguments{
\item{longlat}{Matrix of longitude and latitude or eastness and northness (two columns in this order) of species occurrence records.}

\item{layers}{Raster* object as defined by package raster to serve as model to create distance layer.}

\item{type}{text string indicating whether the output should be the "minimum", "average" or "mcp" distance to all records. "mcp" means the distance to the minimum convex polygon encompassing all records.}
}
\value{
A RasterLayer object.
}
\description{
Create a layer depicting minimum, average or maximum distance to records.
}
\details{
Using distance to records in models may help limiting the extrapolation of the predicted area much beyond known areas.
}
\examples{
data(red.layers)
data(red.records)
par(mfrow=c(2,2))
raster::plot(red.layers[[1]])
points(red.records)
raster::plot(raster.distance(red.records, red.layers))
raster::plot(raster.distance(red.records, red.layers, type = "average"))
raster::plot(raster.distance(red.records, red.layers, type = "mcp"))
}
