% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportPDF.R
\name{exportPdf}
\alias{exportPdf}
\alias{exportPdf.redcapDbConnection}
\alias{exportPdf.redcapApiConnection}
\title{Export PDF file of Data Collection Instruments (either as blank or with data)}
\usage{
exportPdf(
  rcon,
  dir,
  filename = "redcap_forms_download",
  record = NULL,
  events = NULL,
  instruments = NULL,
  all_records = FALSE,
  ...
)

\method{exportPdf}{redcapDbConnection}(
  rcon,
  dir,
  filename = "redcap_forms_download",
  record = NULL,
  events = NULL,
  instruments = NULL,
  all_records = FALSE,
  ...
)

\method{exportPdf}{redcapApiConnection}(
  rcon,
  dir,
  filename = "redcap_forms_download",
  record = NULL,
  events = NULL,
  instruments = NULL,
  all_records = FALSE,
  ...,
  error_handling = getOption("redcap_error_handling")
)
}
\arguments{
\item{rcon}{A REDCap connection object as generated by \code{redcapConnection}.}

\item{dir}{The directory into which the file should be saved.}

\item{filename}{\code{character(1)}. The base of the file name.  If 
\code{record = NULL}, it will be appended with \code{"_blank.pdf"}.  If 
\code{record} has a value, it will be appended with \code{"_record_[record id].pdf"}}

\item{record}{The record id for which forms should be downloaded.  May only 
have length 1.}

\item{events}{The events for which forms should be downloaded}

\item{instruments}{The instruments for which forms should be downloaded}

\item{all_records}{Logical. If \code{TRUE} forms for all records are downloaded.
When \code{TRUE}, this overrides the \code{records} argument.}

\item{...}{Arguments to be passed to other methods.}

\item{error_handling}{An option for how to handle errors returned by the API.
see \code{\link{redcap_error}}}
}
\value{
Creates a PDF file that is saved to the directory specified by the user.
}
\description{
This function allows you to download PDF files of data collection 
instruments.  The download may be with or without collected data, and may 
return a single record, multiple records, or all records.
}
\details{
This function mimics the behavior of "Download PDF of Instruments" button on the
REDCap user interface.
}
\section{REDCap API Documentation}{

This function allows you to export a PDF file for any of the following: 1) a 
single data collection instrument (blank), 2) all instruments (blank), 3) a 
single instrument (with data from a single record), 4) all instruments (with 
data from a single record), or 5) all instruments (with data from ALL records). 
This is the exact same PDF file that is downloadable from a project's data entry 
form in the web interface, and additionally, the user's privileges with regard to 
data exports will be applied here just like they are when downloading the PDF in 
the web interface (e.g., if they have de-identified data export rights, then it 
will remove data from certain fields in the PDF). If the user has "No Access" data 
export rights, they will not be able to use this method, and an error will be returned.
}

\section{REDCap Version}{

6.5.0+
}

\section{Known REDCap Limitations}{

None
}

\author{
Benjamin Nutter
}
