% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportInstruments.R
\name{exportInstruments}
\alias{exportInstruments}
\alias{exportInstruments.redcapApiConnection}
\title{Exports the REDCap Instruments}
\usage{
exportInstruments(rcon, ...)

\method{exportInstruments}{redcapApiConnection}(
  rcon,
  ...,
  error_handling = getOption("redcap_error_handling")
)
}
\arguments{
\item{rcon}{A REDCap connection object as generated by \code{redcapConnection}}

\item{...}{Arguments to be passed to other methods.}

\item{error_handling}{An option for how to handle errors returned by the API.
see \code{\link{redcap_error}}}
}
\description{
Returns a data frame of instruments, names, etc.
}
\section{REDCap Version}{

6.5.0 +


5.8.2+
}

\section{REDCap API Documentation}{

This function allows you to export a list of the data collection instruments 
for a project. This includes their unique instrument name as seen in the second 
column of the Data Dictionary, as well as each instrument's corresponding 
instrument label, which is seen on a project's left-hand menu when entering data. 
The instruments will be ordered according to their order in the project.
}

\section{Known REDCap Limitations}{
 
None
}

\references{
Please refer to your institution's API documentation.

Additional details on API parameters are found on the package wiki at
\url{https://github.com/vubiostat/redcapAPI/wiki/REDCap-API-Parameters}
}
\author{
Benjamin Nutter
}
