% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importRepeatingInstrumentsEvents.R
\name{importRepeatingInstrumentsEvents}
\alias{importRepeatingInstrumentsEvents}
\alias{importRepeatingInstrumentsEvents.redcapApiConnection}
\title{Import Repeating Instruments and Events Settings}
\usage{
importRepeatingInstrumentsEvents(rcon, data, ...)

\method{importRepeatingInstrumentsEvents}{redcapApiConnection}(
  rcon,
  data,
  refresh = TRUE,
  ...,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{data}{\code{data.frame}. For classical projects, it must have the
columns \code{form_name} and \code{custom_form_label}. Longitudinal
projects also require a column for \code{event_name}.}

\item{...}{additional arguments to pass to other methods.}

\item{refresh}{\code{logical(1)} If \code{TRUE}, the cached 
value of repeating instruments and events on \code{rcon} will be
refreshed.}

\item{error_handling}{An option for how to handle errors returned by the API.
see \code{\link{redcap_error}}}

\item{config}{\code{list} Additional configuration parameters to pass to 
\code{\link[httr]{POST}}. These are appended to any parameters in 
\code{rcon$config}.}

\item{api_param}{\code{list} Additional API parameters to pass into the
body of the API call. This provides users to execute calls with options
that may not otherwise be supported by \code{redcapAPI}.}
}
\description{
This method allows you to import a list of the repeated 
  instruments and repeating events for a project. This includes their 
  unique instrument name as seen in the second column of the Data 
  Dictionary, as well as each repeating instrument's corresponding custom 
  repeating instrument label. For longitudinal projects, the unique 
  event name is also needed for each repeating instrument. Additionally, 
  repeating events must be submitted as separate items, in which the 
  instrument name will be blank/null to indicate that it is a repeating 
  event (rather than a repeating instrument).
}
\details{
It should be noted that it is \emph{not} possible to update the
\code{has_repeating_instruments_or_events} property of the project through
\code{importProjectInformation}. Enabling of repeating instruments and 
events must be done through the GUI.

Although the API does not provide a delete method, it is possible to 
remove settings by doing an import that excludes the settings you wish
to remove. All settings can be cleared by executing
\code{importRepeatingInstrumentsEvents(rcon, REDCAP_REPEAT_INSTRUMENT_STRUCTURE)}.
}
