% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unlockREDCap.R
\name{unlockREDCap}
\alias{unlockREDCap}
\title{Open REDCap connections using cryptolocker for storage of API_KEYs.}
\usage{
unlockREDCap(
  connections,
  url,
  keyring,
  envir = NULL,
  passwordFUN = .default_pass(),
  ...
)
}
\arguments{
\item{connections}{character vector. A list of strings that define the
connections with associated API_KEYs to load into environment. Each
name should correspond to a REDCap project for traceability, but
it can be named anything one desires.
The name in the returned list is this name.}

\item{url}{character. The url of one's institutional REDCap server api.}

\item{keyring}{character. Potential keyring, not used by default.}

\item{envir}{environment. The target environment for the connections. Defaults to NULL
which returns the keys as a list. Use \code{\link[=globalenv]{globalenv()}} to assign in the
global environment. Will accept a number such a '1' for global as well.}

\item{passwordFUN}{function. Function to get the password for the keyring. Usually defaults \code{getPass::getPass}.
On MacOS it will use rstudioapi::askForPassword if available.}

\item{\dots}{Additional arguments passed to \code{\link[=redcapConnection]{redcapConnection()}}.}
}
\value{
If \code{envir} is NULL returns a list of opened connections. Otherwise
connections are assigned into the specified \code{envir}.
}
\description{
Opens a set of connections to REDcap from API_KEYs stored in an encrypted keyring.
If the keyring does not exist, it will ask for password to this keyring to use on
later requests. Next it
will ask for the API_KEYs specified in \code{connections}. If an API_KEY does not
work, it will request again. On later executions it will use an open keyring
to retrieve all API_KEYs or for a password if the keyring is currently
locked.
}
\details{
If one forgets the password to this keyring, or wishes to start over:
\code{keyring::keyring_delete("<NAME_OF_KEY_RING_HERE>")}

Consistent behavior requires \code{options(keyring_backend=keyring::backend_file)} to
be set. It is recommended to place this in \verb{~/.Rprofile}.

For production servers where the password must be stored in a readable
plain text file, it will search for \verb{../<basename>.yml}. DO NOT USE
this unless one is a sysadmin, as this defeats the security and purpose of
a local encrypted file. The expected structure of this yaml file is
as follows:

\preformatted{
other-config-stuff1: blah blah
redcapAPI:
  keys:
    intake: THIS_IS_THE_INTAKE_DATABASE_APIKEY
    details: THIS_IS_THE_DETAILS_DATABASE_APIKEY
other-config-stuff2: blah blah
other-config-stuff3: blah blah
}

For production servers the use of ENV variables is also supported. The connection
string is converted to upper case for the search of ENV. If a YAML
and ENV variable both exist, the YAML will take precedence.

IMPORTANT: Make sure that R is set to NEVER save workspace to .RData
as this \emph{is} writing the API_KEY to a local file in clear text because
connection objects contain the unlocked key in memory. Tips
are provided in \code{vignette("redcapAPI-best-practices")}.
}
\examples{
\dontrun{
options(keyring_backend=keyring::backend_file) # Put in .Rprofile

unlockREDCap(c(test_conn    = 'TestRedcapAPI',
               sandbox_conn = 'SandboxAPI'),
             keyring      = '<NAME_OF_KEY_RING_HERE>',
             envir        = globalenv(),
             url          = 'https://<INSTITUTIONS_REDCAP_DOMAIN>/api/') 
}
}
\seealso{
\code{\link[=redcapConnection]{redcapConnection()}}
\subsection{Vignettes}{

\code{vignette("redcapAPI-best-practices")}, \cr
\code{vignette("redcapAPI-getting-started-connecting")}
}
}
