% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enumpart.R
\name{redist.prep.enumpart}
\alias{redist.prep.enumpart}
\title{Prepares a run of the enumpart algorithm by ordering edges}
\usage{
redist.prep.enumpart(adjlist, unordered_path, ordered_path)
}
\arguments{
\item{adjlist}{zero indexed adjacency list}

\item{unordered_path}{valid path to output the unordered adjacency map to}

\item{ordered_path}{valid path to output the ordered adjacency map to}
}
\value{
0 on success
}
\description{
Prepares a run of the enumpart algorithm by ordering edges
}
\examples{
\dontrun{
data("algdat.p10")
redist.prep.enumpart(adjlist = algdat.p10$adjlist, unordered_path = '../unordered', 
ordered_path = '../ordered')
}
}
\references{
Benjamin Fifield, Kosuke Imai, Jun Kawahara, and Christopher T Kenny.
"The Essential Role of Empirical Validation in Legislative Redistricting Simulation." 
Forthcoming, Statistics and Public Policy.
}
