% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{merge_by}
\alias{merge_by}
\title{Merge map units}
\usage{
merge_by(.data, ..., by_existing = TRUE, drop_geom = TRUE, collapse_chr = TRUE)
}
\arguments{
\item{.data}{a \code{\link{redist_map}} object}

\item{...}{\code{\link[dplyr:dplyr_tidy_select]{<tidy-select>}} the column(s) to merge by}

\item{by_existing}{if an existing assignment is present, whether to also group by it}

\item{drop_geom}{whether to drop the geometry column. Recommended, as
otherwise a costly geometric merge is required.}

\item{collapse_chr}{if \code{TRUE}, preserve character columns by collapsing
their values. For example, a county name column in Iowa might be merged and
have entries such as "Cedar~Clinton~Des Moines". Set to \code{FALSE} to
drop character columns instead.}
}
\value{
A merged \code{\link{redist_map}} object
}
\description{
In performing a county-level or cores-based analysis it is often necessary to
merge several units together into a larger unit.  This function performs this
operation, modifying the adjacency graph as needed and attempting to properly
aggregate other data columns.
}
\concept{prepare}
