% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redist_mcmc.R
\name{redist.combine.anneal}
\alias{redist.combine.anneal}
\title{redist.combine.anneal}
\usage{
redist.combine.anneal(file_name)
}
\arguments{
\item{file_name}{The file name to search for in current working directory.}
}
\value{
\code{redist.combine.anneal} returns an object of class "redist". The object
\code{redist} is a list that contains the following components (the
inclusion of some components is dependent on whether tempering
techniques are used):
\item{plans}{Matrix of congressional district assignments generated by the
algorithm. Each row corresponds to a geographic unit, and each column
corresponds to a simulation.}
\item{distance_parity}{Vector containing the maximum distance from parity for
a particular simulated redistricting plan.}
\item{mhdecisions}{A vector specifying whether a proposed redistricting plan
was accepted (1) or rejected (0) in a given iteration.}
\item{mhprob}{A vector containing the Metropolis-Hastings acceptance
probability for each iteration of the algorithm.}
\item{pparam}{A vector containing the draw of the \code{p} parameter for each
simulation, which dictates the number of swaps attempted.}
\item{constraint_pop}{A vector containing the value of the population
constraint for each accepted redistricting plan.}
\item{constraint_compact}{A vector containing the value of the compactness
constraint for each accepted redistricting plan.}
\item{constraint_segregation}{A vector containing the value of the
segregation constraint for each accepted redistricting plan.}
\item{constraint_vra}{A vector containing the value of the
vra constraint for each accepted redistricting plan.}
\item{constraint_similar}{A vector containing the value of the similarity
constraint for each accepted redistricting plan.}
\item{constraint_partisan}{A vector containing the value of the
partisan constraint for each accepted redistricting plan.}
\item{constraint_minority}{A vector containing the value of the
minority constraint for each accepted redistricting plan.}
\item{constraint_hinge}{A vector containing the value of the
hinge constraint for each accepted redistricting plan.}
\item{beta_sequence}{A vector containing the value of beta for each iteration
of the algorithm. Returned when tempering is being used.}
\item{mhdecisions_beta}{A vector specifying whether a proposed beta value was
accepted (1) or rejected (0) in a given iteration of the algorithm. Returned
when tempering is being used.}
\item{mhprob_beta}{A vector containing the Metropolis-Hastings acceptance
probability for each iteration of the algorithm. Returned when tempering
is being used.}
}
\description{
Combine files generated by redist.flip.anneal()
}
\concept{post}
