% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redist_shortburst.R
\name{scorer_group_pct}
\alias{scorer_group_pct}
\alias{scorer_pop_dev}
\alias{scorer_splits}
\alias{scorer_multisplits}
\alias{scorer_frac_kept}
\alias{scorer_polsby_popper}
\alias{scorer_status_quo}
\alias{scorers}
\title{Scoring functions for \code{redist_shortburst}}
\usage{
scorer_group_pct(map, group_pop, total_pop, k = 1)

scorer_pop_dev(map)

scorer_splits(map, counties)

scorer_multisplits(map, counties)

scorer_frac_kept(map)

scorer_polsby_popper(map, perim_df = NULL, areas = NULL, m = 1)

scorer_status_quo(map, existing_plan = get_existing(map))
}
\arguments{
\item{map}{A \code{\link{redist_map}} object.}

\item{group_pop}{A numeric vector with the population of the group for every precinct.}

\item{total_pop}{A numeric vector with the population for every precinct.}

\item{k}{the k-th from the top group fraction to return as the score.}

\item{counties}{A numeric vector with an integer from 1:n_counties}

\item{perim_df}{perimeter distance dataframe from \code{\link{redist.prep.polsbypopper}}}

\item{areas}{area of each precinct (ie \code{st_area(map)})}

\item{m}{the m-th from the bottom Polsby Popper to return as the score. Defaults to 1,
the minimum Polsby Popper score}

\item{existing_plan}{A vector containing the current plan.}
}
\value{
A scoring function of class \code{redist_scorer}. single numeric value, where larger values are better for \code{frac_kept},
\code{group_pct}, and \code{polsby_popper} and smaller values are better for \code{splits} and \code{pop_dev}.
}
\description{
The output of these functions may be passed into \code{redist_shortburst()} as
\code{score_fn}.  Scoring functions have type \code{redist_scorer} and may be combined
together using basic arithmetic operations.
}
\details{
Function details:
\itemize{
\item \code{scorer_group_pct} returns the \code{k}-th top group percentage across districts.
For example, if the group is Democratic voters and \code{k=3}, then the function
returns the 3rd-highest fraction of Democratic voters across all districts.
Can be used to target \code{k} VRA districts or partisan gerrymanders.
\item \code{scorer_pop_dev} returns the maximum population deviation within a plan.
Smaller values are closer to population parity, so use \code{maximize=FALSE} with
this scorer.
\item \code{scorer_splits} returns the fraction of counties that are split within a
plan. Higher values have more county splits, so use \code{maximize=FALSE} with
this scorer.
\item \code{scorer_frac_kept} returns the fraction of edges kept in each district.
Higher values mean more compactness.
\item \code{scorer_polsby_popper} returns the \code{m}-th Polsby Popper score within a plan.
Higher scores correspond to more compact districts.  Use \code{m=ndists/2} to
target the median compactness, \code{m=1} to target the minimum compactness.
\item \code{scorer_status_quo} returns 1 - the rescaled variation of information
distance between the plan and the \code{existing_plan}. Larger values indicate the
plan is closer to the existing plan.
}
}
\examples{
\donttest{
data(iowa)
iowa_map = redist_map(iowa, existing_plan=cd_2010, pop_tol=0.05, total_pop = pop)

scorer_frac_kept(iowa_map)
scorer_status_quo(iowa_map)
scorer_group_pct(iowa_map, dem_08, tot_08, k=2)
1.5*scorer_frac_kept(iowa_map) + 0.4*scorer_status_quo(iowa_map)
1.5*scorer_frac_kept(iowa_map) + scorer_frac_kept(iowa_map)*scorer_status_quo(iowa_map)
}

}
\concept{prepare}
