% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partisan.R
\name{part_resp}
\alias{part_resp}
\title{Calculate Responsiveness}
\usage{
part_resp(plans, shp, dvote, rvote, v = 0.5, bandwidth = 0.01)
}
\arguments{
\item{plans}{redist_plans object or plans_matrix where each row indicates a district assignment and each column is a plan}

\item{shp}{redist_map object or tibble with sf geometry column}

\item{dvote}{unqouted name of column in shp with total population}

\item{rvote}{unqouted name of column in shp with group population}

\item{v}{vote share to calculate bias at. Numeric. Default is 0.5.}

\item{bandwidth}{Defaults to 0.01. A value between 0 and 1 for the step size to estimate the slope.}
}
\value{
numeric vector
}
\description{
Calculate Responsiveness
}
\examples{
data(nh)
data(nh_m)
# For a single plan:
part_resp(plans = nh$r_2020, shp = nh, rvote = nrv, dvote = ndv)

# Or many plans:
part_resp(plans = nh_m[, 3:5], shp = nh, rvote = nrv, dvote = ndv)

}
\references{
Jonathan N. Katz, Gary King, and Elizabeth Rosenblatt. 2020.
Theoretical Foundations and Empirical Evaluations of Partisan Fairness in District-Based Democracies.
American Political Science Review, 114, 1, Pp. 164-178.
}
\concept{partisan}
