% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refseq_fromXM.R
\name{refseq_fromXM}
\alias{refseq_fromXM}
\title{Get mRNA features}
\usage{
refseq_fromXM(xm , feat)
}
\arguments{
\item{xm}{A character string of the XM id.}

\item{feat}{A character string of the selected features. Allowed features: 'caption',
'moltype', 'sourcedb', 'updatedate', 'slen', 'organism', 'title'.}
}
\value{
A \code{tibble} of summarized results including columns:
\itemize{
\item caption, mRNA accession
\item moltype, type of molecule
\item sourcedb, database (GenBank)
\item updatedate, date of updated record
\item slen, molecule length (in bp)
\item organism
\item title, sequence description
}
}
\description{
\code{refseq_fromXM()} Returns a number of features from a single/multiple mRNA accession(s).
}
\examples{
# Get several molecular features from a set of mRNA accessions
xm = c("XM_004487701", "XM_004488493", "XM_004501904")
feat = c("caption", "moltype", "sourcedb", "slen")
refseq_fromXM(xm ,feat)

}
\seealso{
\code{\link{refseq_fromGene}} to obtain the XP or XM accession from a single gene id. accession.

\code{\link{refseq_XPfromXM}} to obtain the XP ids encoded by a set of XM ids.
}
\author{
Jose V. Die
}
