% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refseq_description.R
\name{refseq_description}
\alias{refseq_description}
\title{Get the sequence Description}
\usage{
refseq_description(id)
}
\arguments{
\item{id}{A character string of the transcript, protein, or GeneID accession.}
}
\value{
A character vector containing the sequence description corresponding to the specified sequence as \code{id}.
}
\description{
\code{refseq_description()} Returns the sequence description from a single transcript, protein, or GeneID accession.

Depending on the function, available accessions in \code{refseqR} include RefSeq models with the prefixes transcript_ (mRNA), XR_ (non-coding RNA), and XP_ (protein), as well as subsequently curated RefSeq records with NM_, NR_, or NP_ accession prefixes.
}
\examples{
 # Get the sequence descriptions from a set of transcript accessions
 transcript = c("XM_004487701")
 sapply(transcript, function(x) refseq_description(x), USE.NAMES = FALSE)

 # Get the sequence descriptions from a set of XP accessions
 protein = c("XP_004487758")
 sapply(protein, function(x) refseq_description(x), USE.NAMES = FALSE)

\donttest{
#' # Get the sequence descriptions from a set of Gene accessions
locs <- c("LOC101512347", "LOC101506901")
sapply(locs, function(x) refseq_description(x), USE.NAMES = FALSE)}

}
\seealso{
\code{\link{refseq_protein2mRNA}} to obtain the transcript ids that encode a set of protein ids.

\code{\link{refseq_mRNA2protein}} to obtain the protein ids encoded by a set of transcript ids.
}
\author{
Jose V. Die
}
