% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/DTI2-data.R
\docType{data}
\name{DTI2}
\alias{DTI2}
\title{Diffusion Tensor Imaging: more fractional anisotropy profiles and outcomes}
\format{A data frame made up of \describe{
\item{cca}{a 340 x 93
matrix of fractional anisotropy profiles from the corpus callosum;}
\item{rcst}{a 340 x 55 matrix of fractional anisotropy
profiles from the right corticospinal tract;}
\item{id}{numeric vector of subject ID numbers;}
\item{visit}{numeric vector of the
subject-specific visit numbers;}
\item{pasat}{numeric vector
containing the PASAT score at each visit.}
}}
\description{
A diffusion tensor imaging dataset used in Swihart et al. (2012). Mean
diffusivity profiles for the corpus callosum (cca) and parallel diffusivity
for the right corticospinal tract (rcst). Accompanying the profiles are the
subject ID numbers, visit number, and Paced Auditory Serial Addition Test
(pasat) score. We thank Dr. Daniel Reich for making this dataset available.
}
\details{
If you use this data as an example in written work, please include the
following acknowledgment: ``The MRI/DTI data were collected at Johns
Hopkins University and the Kennedy-Krieger Institute"

Note: DTI2 uses mean diffusivity of the the corpus callosum rather than
fractional anisotropy (FA), and parallel diffusivity of the rcst rather
than FA. Please see the documentation for DTI for more about the DTI
dataset.
}
\references{
Goldsmith, J., Bobb, J., Crainiceanu, C., Caffo, B., and Reich,
D. (2011). Penalized functional regression. \emph{Journal of Computational
and Graphical Statistics}, 20(4), 830--851.

Goldsmith, J., Crainiceanu, C., Caffo, B., and Reich, D. (2012).
Longitudinal penalized functional regression for cognitive outcomes on
neuronal tract measurements. \emph{Journal of the Royal Statistical
Society: Series C}, 61(3), 453--469.

Swihart, B. J., Goldsmith, J., and Crainiceanu, C. M. (2012). Testing for
functional effects.  Johns Hopkins University Dept. of Biostatistics
Working Paper 247. Available at
\url{http://biostats.bepress.com/jhubiostat/paper247}
}
\keyword{datasets}

