% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regFMF.R
\name{regFMF}
\alias{regFMF}
\alias{regFMF.default}
\alias{regFMF.formula}
\title{Fusion of Multiple Filters for Regression}
\usage{
\method{regFMF}{default}(x, y, t = 0.2, vote = FALSE, ...)

\method{regFMF}{formula}(formula, data, ...)
}
\arguments{
\item{x}{a data frame of input attributes.}

\item{y}{a double vector with the output regressand of each sample.}

\item{t}{a double in [0,1] with the \emph{threshold} used by regression noise filter (default: 0.2).}

\item{vote}{a logical indicating if the consensus voting (\code{TRUE}) or majority voting (\code{FALSE}) is used (default: \code{FALSE}).}

\item{...}{other options to pass to the function.}

\item{formula}{a formula with the output regressand and, at least, one input attribute.}

\item{data}{a data frame in which to interpret the variables in the formula.}
}
\value{
The result of applying the regression filter is a reduced dataset containing the clean samples (without errors or noise), since it removes noisy samples (those with errors).
This function returns an object of class \code{rfdata}, which contains information related to the noise filtering process in the form of a list with the following elements:
\item{xclean}{a data frame with the input attributes of clean samples (without errors).}
\item{yclean}{a double vector with the output regressand of clean samples (without errors).}
\item{numclean}{an integer vector with the amount of clean samples.}
\item{idclean}{an integer vector with the indices of clean samples.}
\item{xnoise}{a data frame with the input attributes of noisy samples (with errors).}
\item{ynoise}{a double vector with the output regressand of noisy samples (with errors).}
\item{numnoise}{an integer vector with the amount of noisy samples.}
\item{idnoise}{an integer vector with the indices of noisy samples.}
\item{filter}{the full name of the noise filter used.}
\item{param}{a list of the argument values.}
\item{call}{the function call.}

Note that objects of the class \code{rfdata} support \link{print.rfdata} and \link{summary.rfdata} methods.
}
\description{
Application of the regFMF noise filtering method in a regression dataset.
}
\details{
\emph{Fusion of Multiple Filters for Regression} (regFMF) is an adaptation of \emph{Ensembles of label Noise Filters} (ENF) found in the field of classification,
which creates an ensemble with the AENN, DF and HARF filtering techniques.
Then, each filter generates one vote per sample. A sample is considered as noisy using a voting scheme (indicated by the argument \code{vote}):
if equal to \code{TRUE}, a consensus voting is used (in which a sample is removed if it is misclassified by all the models);
if equal to \code{FALSE}, a majority voting is used (in which a sample is removed if it is misclassified by more than a half of the models).
The implementation of this noise filter to be used in regression problems follows the proposal of Martín \emph{et al.} (2021),
which is based on the use of a noise threshold (\code{t}) to determine the similarity between the output variable of the samples.
}
\examples{
# load the dataset
data(rock)

# usage of the default method
set.seed(9)
out.def <- regFMF(x = rock[,-ncol(rock)], y = rock[,ncol(rock)])

# show results
summary(out.def, showid = TRUE)

# usage of the method for class formula
set.seed(9)
out.frm <- regFMF(formula = perm ~ ., data = rock)

# check the match of noisy indices
all(out.def$idnoise == out.frm$idnoise)

}
\references{
L. Garcia, A. Lorena, S. Matwin and A. de Carvalho,
\strong{Ensembles of label noise filters: a ranking approach},
\emph{Data Mining Knowledge Discovery}, 30:1192–1216, 2016.
\doi{https://doi.org/10.1007/s10618-016-0475-9}.

J. Martín, J. A. Sáez and E. Corchado,
\strong{On the regressand noise problem: Model robustness and synergy with regression-adapted noise filters.}
\emph{IEEE Access}, 9:145800-145816, 2021.
\doi{https://doi.org/10.1109/ACCESS.2021.3123151}.
}
\seealso{
\code{\link{regDF}}, \code{\link{regHRRF}}, \code{\link{regAENN}}, \code{\link{print.rfdata}}, \code{\link{summary.rfdata}}
}
