% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_model.R
\name{coef.block_glm}
\alias{coef.block_glm}
\title{Extract model coefficients.}
\usage{
\method{coef}{block_glm}(object, num = NULL, ...)
}
\arguments{
\item{object}{An object of class "\code{block_glm}", usually, a result of a
call to \code{\link{build_model}}.}

\item{num}{Numeric vector with the index of model(s) from which to return the
coefficients.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
The coefficients of block(s) `num`, or if `num` is NULL, a list of
  coefficients from all blocks.
}
\description{
\code{coef} method for class "\code{block_glm}".
}
\examples{
# 2 blocks: Petal.Length; Petal.Length + Petal.Width
model1 <- build_model(Sepal.Length, Petal.Length, Petal.Width, data=iris, model='lm')
summary(model1)
coef(model1)  # returns both blocks 1 and 2

# 2 blocks: Species; Species + Petal.Length + Petal.Width + Petal.Length:Petal.Width
model2 <- build_model(Sepal.Length, Species, c(Petal.Length * Petal.Width), data=iris, model='lm')
summary(model2)
coef(model2, num=2)  # returns second block
}
\seealso{
\code{\link{build_model}}, \code{coef.block_glm_summary},
  \code{\link{fitted.block_glm}}, \code{residuals.block_glm}
}

