# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Calculate expected score and score variance for the current subject.
#'
#' Calculations derived using maximum likelihood estimation.
#'
#' @param Y vector of observations for the current subject.
#' @param mu vector of spline coefficients for the population mean.
#' @param psi matrix of spline coefficients for the principal component basis functions.
#' @param theta spline basis functions for the current subject.
#' @param theta_quad quadratic form of theta for the current subject.
#' @return A list with expected score mean and variance for the current subject.
expectedScores <- function(Y, mu, psi, theta, theta_quad) {
    .Call('_registr_expectedScores', PACKAGE = 'registr', Y, mu, psi, theta, theta_quad)
}

#' Estimate variational parameter for the current subject.
#'
#' Function calculates value of variational parameter using maximum likelihood.
#'
#' @param theta spline basis functions for the current subject.
#' @param mu vector of spline coefficients for the population mean.
#' @param mi vector of expected mean scores for the current subject.
#' @param psi matrix of spline coefficients for the principal component basis functions.
#' @param Ci expected covariance matrix of scores for the current subject.
#' @return A vector of variational parameters for the current subject.
expectedXi <- function(theta, mu, mi, psi, Ci) {
    .Call('_registr_expectedXi', PACKAGE = 'registr', theta, mu, mi, psi, Ci)
}

#' Apply lambda transformation of variational parameter.
#'
#' Simple function for use within other C++ functions.
#'
#' @param x The value to which you apply the function
#' @return A numeric value that has been transformed.
lambdaF <- function(x) {
    .Call('_registr_lambdaF', PACKAGE = 'registr', x)
}

#' Calculate quadratic form of spline basis functions for the current subject.
#'
#' Calculations quadratic form of theta with diagonalized variational parameter in the center.
#'
#' @param xi vector of variational parameters for the current subject.
#' @param theta spline basis functions for the current subject.
#' @return A matrix of the quadratic form of theta for the current subject.
squareTheta <- function(xi, theta) {
    .Call('_registr_squareTheta', PACKAGE = 'registr', xi, theta)
}

