% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/registr-utils.R
\name{piecewise_linear2_hinv}
\alias{piecewise_linear2_hinv}
\title{Create two-parameter piecewise linear (inverse) warping functions}
\usage{
piecewise_linear2_hinv(grid, knot_locations = c(0.25, 0.3, 0.75, 0.9))
}
\arguments{
\item{grid}{grid of values over which to evaluate the function.}

\item{knot_locations}{controls the x and y locations of the two knots.}
}
\description{
This function uses a 2-knot piecewise linear model to calculate inverse warping 
functions for registration. The parameters \code{knot1_x} and \code{knot1_y}
control the x and y locations of the first knot, and the parameters
\code{knot1_x} and \code{knot1_y} control the x and y locations of the second
knot. The designation (inverse) is intended to communicate that these 
functions take data from the unregistered space to the registered space, 
consistent with functional data literature on registration.
}
\author{
Erin McDonnell \email{eim2117@cumc.columbia.edu}
}
