% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08_regmedint_class_user_methods.R
\name{coef.summary_regmedint}
\alias{coef.summary_regmedint}
\title{Extract the result matrix from a summary_regmedint object.}
\usage{
\method{coef}{summary_regmedint}(object, ...)
}
\arguments{
\item{object}{An object with a class of \code{summary_regmedint}.}

\item{...}{For compatibility with the generic.}
}
\value{
A matrix populated with results.
}
\description{
Extract the result matrix from a summary_regmedint object.
}
\examples{
library(regmedint)
data(vv2015)
regmedint_obj <- regmedint(data = vv2015,
                           ## Variables
                           yvar = "y",
                           avar = "x",
                           mvar = "m",
                           cvar = c("c"),
                           eventvar = "event",
                           ## Values at which effects are evaluated
                           a0 = 0,
                           a1 = 1,
                           m_cde = 1,
                           c_cond = 0.5,
                           ## Model types
                           mreg = "logistic",
                           yreg = "survAFT_weibull",
                           ## Additional specification
                           interaction = TRUE,
                           casecontrol = FALSE)
coef(summary(regmedint_obj))

}
