% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regr_easy_graf.R
\name{regr_easy_graf}
\alias{regr_easy_graf}
\title{Regression Model Graphs: Linear, Quadratic and Cubic.}
\usage{
regr_easy_graf(
  x,
  y,
  model = "L",
  plot_eq = TRUE,
  plot_R2 = TRUE,
  plot_res = TRUE,
  title = "",
  subtitle = "",
  title_x = "x",
  title_y = "y",
  pch = 21,
  pch_size = 2.5,
  pch_fill = "black",
  pch_colour = "black",
  point_max = FALSE,
  equ_pos = NULL,
  R2_pos = NULL,
  l_type = 1,
  l_color = "red",
  col_resid = "red",
  ax_size = 12,
  ax_title_size = 12,
  equ_tex_size = 12,
  pch_max = 4,
  pmax_size = 2.5,
  pmax_fill = "red",
  pmax_col = "red",
  lmax_type = 2,
  lmax_col = "red",
  lmax_size = 0.5,
  lmax_alpha = 1
)
}
\arguments{
\item{x}{Values that should be used as an independent variable for the regression calculation.}

\item{y}{Values that should be used as a dependent variable for the regression calculation.}

\item{model}{Character, defined which model will be calculated. model = "L", calculate the linear, model = "Q" calculate the quadratic, model = "C" calculate the cubic, model = "all" = calculate both). Default "L".}

\item{plot_eq}{Logical, if TRUE (default) plots the regression equation on the graph.}

\item{plot_R2}{Logical, if TRUE (default) plots the regression R-square on the graph.}

\item{plot_res}{Logical, if true (default), it plots segments referring to the residuals in the graph.}

\item{title}{Character, title of the graph.}

\item{subtitle}{Character, subtitle of the graph.}

\item{title_x}{Character, x axis label in plot.}

\item{title_y}{Character, y axis label in plot.}

\item{pch}{y and x plot symbol. Default = 21.}

\item{pch_size, pch_fill, pch_colour}{Size, padding and contour of points (pch) of y and x. Defaults = 2.5, "black", "black").}

\item{point_max}{Logical, if TRUE, the value corresponding to the maximum value will be added to the graph. Valid only for model="Q". Default = FALSE.}

\item{equ_pos}{A vector of 2 values to position the equation on the graph, if NULL will be plotted at a predefined position.}

\item{R2_pos}{A vector of 2 values to position the R-square on the graph, if NULL will be plotted at a predefined position.}

\item{l_type, l_color}{Line type e color to use in the regression equation curve. Defaults = 1,"red".}

\item{col_resid}{Color to be used in the residuals of the regression equation. Default = "red.}

\item{ax_size}{Size for axis marking labels. Default = 12.}

\item{ax_title_size}{Size for axis titles. Defaults = 12,12.}

\item{equ_tex_size}{Size for the regression equation e R-square. Default = 12.}

\item{pch_max}{Symbol of the maximum value of the quadratic regression model. Default = 4.}

\item{pmax_size, pmax_fill, pmax_col}{Size, padding and outline of the maximum value symbol of the quadratic regression model. Defaults = 2.5, "red, "red.}

\item{lmax_type, lmax_col, lmax_size, lmax_alpha}{Type, color, size and transparency of the maximum value line of the quadratic regression model. Defaults = 2, "red", 0.5, 1.}
}
\value{
Returns a ggplot2 for the defined regression model.
}
\description{
It makes graphs for the regression models: linear, quadratic and cubic, allowing the plotting of the R-square, the equation, and other aspects related to regression.
}
\examples{
library(regr.easy)
x <- seq(0,300,50)
y <- c(138.6,153.6,164.525,164.925,158.725,159.975,154.425)
regr_easy_graf(x,y, model = "Q")
}
