% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.furcation.R
\name{plot.furcation}
\alias{plot.furcation}
\title{Plots furcation trees around a focal marker}
\usage{
\method{plot}{furcation}(
  x,
  allele = NA,
  col = c("blue", "red", "violet", "orange"),
  mrk.col = "gray",
  lwd = 0.1,
  hap.names = NULL,
  cex.lab = 1,
  family.lab = "",
  offset.lab = 0.5,
  legend = NA,
  legend.xy.coords = "automatic",
  ...
)
}
\arguments{
\item{x}{an object of class furcation (see \code{\link{calc_furcation}}).}

\item{allele}{If \code{NA} (default), furcation trees for all alleles of the focal marker are plotted,
otherwise for the specified alleles. Alleles must be specified by their
internal coding, i.e. '0' for ancestral resp. major allele, etc.}

\item{col}{color for each allele (as coded internally).}

\item{mrk.col}{color of the vertical line at the focal marker position.}

\item{lwd}{controls the relative width of the diagram lines on the plot (default 0.1).}

\item{hap.names}{a vector containing names of chromosomes.}

\item{cex.lab}{relative size of labels. See \code{\link[graphics]{par}}.}

\item{family.lab}{font family for labels. See \code{\link[graphics]{par}}.}

\item{offset.lab}{offset of labels. See \code{\link[graphics]{par}}.}

\item{legend}{legend text.}

\item{legend.xy.coords}{if \code{"automatic"} (default) places legend either top left or top right;
if \code{"none"}, no legend is drawn; otherwise argument is passed to \code{\link[graphics]{legend}}.}

\item{...}{other arguments to be passed to \code{\link[graphics]{plot.default}}.}
}
\description{
Plots furcation trees around a focal marker
}
\examples{
#example haplohh object (280 haplotypes, 1424 SNPs)
#see ?haplohh_cgu_bta12 for details
data(haplohh_cgu_bta12)
#plotting furcation diagram for both ancestral and derived allele
#from the marker "F1205400"
#which display a strong signal of selection
f <- calc_furcation(haplohh_cgu_bta12, mrk = "F1205400")
plot(f)
plot(f, xlim = c(2e+07,3.5e+07))
plot(f, xlim = c(2.7e+07,3.1e+07))
plot(f, xlim = c(2.7e+07,3.1e+07), hap.names = hap.names(haplohh_cgu_bta12), cex.lab=0.3)
}
\seealso{
\code{\link{plot.haplen}}.
}
