% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/environment.R
\name{Environment}
\alias{Environment}
\title{Custom Reinforcement Learning Environment}
\arguments{
\item{step}{[\code{function(self, action)}] \cr
Custom step function.}

\item{reset}{[\code{function(self)}] \cr
Custom reset function.}

\item{visualize}{[\code{function(self)}] \cr
Optional custom visualization function.}

\item{discount}{[\code{numeric(1)} in (0, 1)] \cr Discount factor.}

\item{action.names}{[\code{named integer}] \cr
Optional action names for a discrete action space.}
}
\description{
Custom Reinforcement Learning Environment
}
\section{Usage}{

\code{makeEnvironment("custom", step, reset, visualize = NULL, discount = 1, action.names = NULL)}
}

\section{Methods}{

\itemize{
\item \code{$step(action)} \cr
Take action in environment.
Returns a list with \code{state}, \code{reward}, \code{done}.
\item \code{$reset()} \cr
Resets the \code{done} flag of the environment and returns an initial state.
Useful when starting a new episode.
\item \code{$visualize()} \cr
Visualizes the environment (if there is a visualization function).
}
}

\examples{
step = function(self, action) {
  state = list(mean = action + rnorm(1), sd = runif(1))
  reward = rnorm(1, state[[1]], state[[2]])
  done = FALSE
  list(state, reward, done)
}

reset = function(self) {
  state = list(mean = 0, sd = 1)
  state
}

env = makeEnvironment(step = step, reset = reset)
env$reset()
env$step(100)
}
