% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remify.R
\name{getRiskset}
\alias{getRiskset}
\alias{getRiskset.remify}
\title{getRiskset}
\usage{
getRiskset(x)

\method{getRiskset}{remify}(x)
}
\arguments{
\item{x}{a \code{remify} object.}
}
\value{
list of objects describing the processed the risk set.
}
\description{
This function returns the processed risk set changes specified by the input `omit_dyad`. In such a matrix: value 1 refers to the dyads in the risk set, and 0 otherwise (dyads excluded from the risk set). All the possible risk set modifications are described by row, and the columns identify the dyads. Note: This matrix is the output given by processing the input `omit_dyad`, and the number of rows might be equal to or higher than the number of objects in `omit_dyad`. This might happen because more than one modification of the risk set defined in the input could overlap over time with others. For more details about how the risk set is processed, see \code{vignette(package="remify",topic="riskset")}.
}
\section{Methods (by class)}{
\itemize{
\item \code{getRiskset(remify)}: manual riskset object

}}
\examples{

# processing the random network 'randomREH'
library(remify)
data(randomREH)
reh <- remify(edgelist = randomREH$edgelist,
              model = "tie",
              riskset = "manual",
              omit_dyad = randomREH$omit_dyad)

# structure of the processed risk set
str(getRiskset(reh))

}
