% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{prep_MCMC}
\alias{prep_MCMC}
\title{Extract MCMC samples of monitored parameters from JointAI object. Code from JointAI.}
\usage{
prep_MCMC(object, treatment = NULL, delta = 0, start = NULL,
  end = NULL, thin = NULL, subset = FALSE, exclude_chains = NULL,
  warn = TRUE, mess = TRUE, ...)
}
\arguments{
\item{object}{an object of class JointAI}

\item{treatment}{the variable name of treatment. Reference level of treatment should be coded as 0.}

\item{delta}{specific value used for Delta adjustment, applicable only
for method="delta".}

\item{start}{first iteration to be used}

\item{end}{last iteration to be used}

\item{thin}{thinning to be applied}

\item{subset}{subset of parameters (columns of the mcmc object) to be used}

\item{exclude_chains}{optional vector of numbers, indexing MCMC chains to be}

\item{warn}{logical, should warning messages be displayed?}

\item{mess}{logical, should messages be displayed?}

\item{...}{optional arguments passed from \code{remiod}.}
}
\description{
Extract MCMC samples of monitored parameters from JointAI object. Code from JointAI.
}
\keyword{internal}
