% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tang_MI_RB.R
\name{tang_MI_RB}
\alias{tang_MI_RB}
\title{Implement controlled multiple imputation algorithms proposed by Tang}
\usage{
tang_MI_RB(object, dtimp, treatment, method = "MAR", delta = 0,
  ord_cov_dummy = FALSE, exclude_chains = NULL, include = FALSE)
}
\arguments{
\item{object}{object inheriting from class 'remoid'}

\item{dtimp}{imputed complete data sets from \code{remiod} function.}

\item{treatment}{treatment variable.}

\item{method}{a method for obtaining multiple-imputed dataset. Options include
\code{MAR}, \code{J2R}, \code{CR}, and \code{delta} adjustment.
Default is MAR.}

\item{delta}{specific value used for Delta adjustment, applicable only
for method="delta".}

\item{ord_cov_dummy}{optional. specify whether ordinal variables should be treated as
categorical variables or continuous variables when they are
included as covariates in the sequential imputation models.
Default is \code{TRUE}, dummy variables will be created accordingly.}

\item{exclude_chains}{optional vector of the index numbers of chains that
should be excluded}

\item{include}{logical, if TRUE, raw data will be included in imputed data sets
with imputation ID = 0.}
}
\value{
multiple imputed datasets stacked onto each other (i.e., long format;
optionally including the original incomplete data).\cr
The variable \code{Imputation_} indexes the imputation, while
\code{.rownr} links the rows to the rows of the original data.
In cross-sectional datasets the
variable \code{.id} is added as subject identifier.
}
\description{
Internal function, creates multiple imputed datasets based on assigned
imputation method with the algorithm of Tang's sequential modeling.
}
