% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install-svn.R
\name{install_svn}
\alias{install_svn}
\title{Install a package from a SVN repository}
\usage{
install_svn(url, subdir = NULL, args = character(0), ..., revision = NULL)
}
\arguments{
\item{url}{Location of package. The url should point to a public or
private repository.}

\item{subdir}{A sub-directory withing a svn repository that contains the
package we are interested in installing.}

\item{args}{A character vector providing extra options to pass on to
\command{svn}.}

\item{...}{Other arguments passed on to \code{\link[utils]{install.packages}}.}

\item{revision}{svn revision, if omitted updates to latest}
}
\description{
This function requires \command{svn} to be installed on your system in order to
be used.
}
\details{
It is vectorised so you can install multiple packages with
a single command.
}
\examples{
\dontrun{
install_svn("svn://github.com/hadley/stringr/trunk")
install_svn("svn://github.com/hadley/httr/branches/oauth")
}
}
