% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cormatrix_excel.R
\name{cormatrix_excel}
\alias{cormatrix_excel}
\title{Easy export of correlation matrix to Excel}
\usage{
cormatrix_excel(
  data,
  filename,
  overwrite = TRUE,
  p_adjust = "none",
  print.mat = TRUE,
  ...
)
}
\arguments{
\item{data}{The data frame}

\item{filename}{Desired filename (path can be added before hand
but no need to specify extension).}

\item{overwrite}{Whether to allow overwriting previous file.}

\item{p_adjust}{Default p-value adjustment method (default is "none",
although \code{\link[correlation:correlation]{correlation::correlation()}}'s default is "holm")}

\item{print.mat}{Logical, whether to also print the correlation matrix
to console.}

\item{...}{Parameters to be passed to the \code{correlation} package
(see \code{\link[correlation:correlation]{correlation::correlation()}})}
}
\value{
A Microsoft Excel document, containing the colour-coded
correlation matrix with significance stars, on the first
sheet, and the colour-coded p-values on the second sheet.
}
\description{
Easily output a correlation matrix and export it to
Microsoft Excel, with the first row and column frozen, and
correlation coefficients colour-coded based on effect size
(0.0-0.2: small (no colour); 0.2-0.4: medium (pink/light blue);
0.4-1.0: large (red/dark blue)), following Cohen's suggestions
for small (.10), medium (.30), and large (.50) correlation sizes.

Based on the \code{correlation} and \code{openxlsx2} packages.
}
\details{
For the \emph{easystats} equivalent, see:
\code{\link[correlation:cormatrix_to_excel]{correlation::cormatrix_to_excel()}}.
}
\examples{
\dontshow{if (requireNamespace("correlation", quietly = TRUE) && requireNamespace("openxlsx2", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontshow{
.old_wd <- setwd(tempdir())
}
# Basic example
cormatrix_excel(mtcars, select = c("mpg", "cyl", "disp", "hp", "carb"), filename = "cormatrix1")
cormatrix_excel(iris, p_adjust = "none", filename = "cormatrix2")
cormatrix_excel(airquality, method = "spearman", filename = "cormatrix3")
\dontshow{
setwd(.old_wd)
}
\dontshow{\}) # examplesIf}
}
\author{
Adapted from @JanMarvin (JanMarvin/openxlsx2#286) and
the original \link{cormatrix_excel} (now imported from
\link[correlation:cormatrix_to_excel]{correlation::cormatrix_to_excel}).
}
\keyword{Excel}
\keyword{correlation}
\keyword{matrix}
