% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\docType{data}
\name{paths}
\alias{paths}
\title{Path Customization}
\format{
An object of class \code{list} of length 5.
}
\usage{
paths
}
\description{
Access the paths that \code{renv} uses for global state storage.
}
\details{
By default, \code{renv} collects state into these folders:

\tabular{ll}{
\strong{Platform} \tab \strong{Location} \cr
Linux        \tab \verb{~/.local/share/renv} \cr
macOS        \tab \verb{~/Library/Application Support/renv} \cr
Windows      \tab \verb{\%LOCALAPPDATA\%/renv} \cr
}

For new installations of \code{renv} using R (>= 4.0.0), \code{renv} will use
\code{\link[tools:userdir]{tools::R_user_dir()}} to resolve the root directory. If an \code{renv} root
directory has already been created in one of the old locations, that will
still be used. This change was made to comply with the CRAN policy
requirements of \R packages. By default, these paths resolve as:

\tabular{ll}{
\strong{Platform} \tab \strong{Location} \cr
Linux        \tab \verb{~/.cache/R/renv} \cr
macOS        \tab \verb{~/Library/Caches/org.R-project.R/R/renv} \cr
Windows      \tab \verb{\%LOCALAPPDATA\%/R/cache/R/renv} \cr
}

If desired, this path can be customized by setting the \code{RENV_PATHS_ROOT}
environment variable. This can be useful if you'd like, for example, multiple
users to be able to share a single global cache.

The various state sub-directories can also be individually adjusted, if so
desired (e.g. you'd prefer to keep the cache of package installations on a
separate volume). The various environment variables that can be set are
enumerated below:

\tabular{ll}{
\strong{Environment Variable}     \tab \strong{Description} \cr
\code{RENV_PATHS_ROOT}            \tab The root path used for global state storage. \cr
\code{RENV_PATHS_LIBRARY}         \tab The path to the project library. \cr
\code{RENV_PATHS_LIBRARY_ROOT}    \tab The parent path for project libraries. \cr
\code{RENV_PATHS_LIBRARY_STAGING} \tab The parent path used for staged package installs. \cr
\code{RENV_PATHS_LOCKFILE}        \tab The path to the \link[=lockfiles]{lockfile}. \cr
\code{RENV_PATHS_CELLAR}          \tab The path to the cellar, containing local package binaries and sources. \cr
\code{RENV_PATHS_SOURCE}          \tab The path containing downloaded package sources. \cr
\code{RENV_PATHS_BINARY}          \tab The path containing downloaded package binaries. \cr
\code{RENV_PATHS_CACHE}           \tab The path containing cached package installations. \cr
\code{RENV_PATHS_PREFIX}          \tab An optional prefix to prepend to the constructed library / cache paths. \cr
\code{RENV_PATHS_RTOOLS}          \tab (Windows only) The path to \href{https://cran.r-project.org/bin/windows/Rtools/}{Rtools}. \cr
\code{RENV_PATHS_EXTSOFT}         \tab (Windows only) The path containing external software needed for compilation of Windows source packages. \cr
\code{RENV_PATHS_MRAN}            \tab The path containing MRAN-related metadata. See \code{vignette("mran", package = "renv")} for more details. \cr
}

Note that \code{renv} will append platform-specific and version-specific entries
to the set paths as appropriate. For example, if you have set:

\if{html}{\out{<div class="sourceCode">}}\preformatted{Sys.setenv(RENV_PATHS_CACHE = "/mnt/shared/renv/cache")
}\if{html}{\out{</div>}}

then the directory used for the cache will still depend on the \code{renv} cache
version (e.g. \code{v2}), the \R version (e.g. \code{3.5}) and the platform (e.g.
\code{x86_64-pc-linux-gnu}). For example:

\if{html}{\out{<div class="sourceCode">}}\preformatted{/mnt/shared/renv/cache/v2/R-3.5/x86_64-pc-linux-gnu
}\if{html}{\out{</div>}}

This ensures that you can set a single \code{RENV_PATHS_CACHE} environment variable
globally without worry that it may cause collisions or errors if multiple
versions of \R needed to interact with the same cache.

If you need to share the same cache with multiple different Linux operating
systems, you may want to set the \code{RENV_PATHS_PREFIX} environment variable
to help disambiguate the paths used on Linux. For example, setting
\code{RENV_PATHS_PREFIX = "ubuntu-bionic"} would instruct \code{renv} to construct a
cache path like:

\if{html}{\out{<div class="sourceCode">}}\preformatted{/mnt/shared/renv/cache/v2/ubuntu-bionic/R-3.5/x86_64-pc-linux-gnu
}\if{html}{\out{</div>}}

If this is required, it's strongly recommended that this environment
variable is set in your \R installation's \code{Renviron.site} file, typically
located at \code{file.path(R.home("etc"), "Renviron.site")}, so that it can be
active for any \R sessions launched on that machine.

Starting from \verb{renv 0.13.0}, you can also instruct \code{renv} to auto-generate
an OS-specific component to include as part of library and cache paths,
by setting the environment variable:

\if{html}{\out{<div class="sourceCode">}}\preformatted{RENV_PATHS_PREFIX_AUTO = TRUE
}\if{html}{\out{</div>}}

The prefix will be constructed based on fields within the system's
\verb{/etc/os-release} file.

If reproducibility of a project is desired on a particular machine, it is
highly recommended that the \code{renv} cache of installed packages + binary
packages is backed up and persisted, so that packages can be easily restored
in the future -- installation of packages from source can often be arduous.

If you want these settings to persist in your project, it is recommended that
you add these to an appropriate \R startup file. For example, these could be
set in:
\itemize{
\item A project-local \code{.Renviron};
\item The user-level \code{.Renviron};
\item A file at \code{file.path(R.home("etc"), "Renviron.site")}.
}

Please see ?\link{Startup} for more details.
}
\section{Package Cellar}{


If your project depends on one or \R packages that are not available in any
remote location, you can still provide a locally-available tarball for \code{renv}
to use during restore. By default, these packages should be made available in
the folder as specified by the \code{RENV_PATHS_CELLAR} environment variable. The
package sources should be placed in a file at one of these locations:
\itemize{
\item \verb{$\{RENV_PATHS_CELLAR\}/<package>_<version>.<ext>}
\item \verb{$\{RENV_PATHS_CELLAR\}/<package>/<package>_<version>.<ext>}
\item \verb{<project>/renv/cellar/<package>_<version>.<ext>}
\item \verb{<project>/renv/cellar/<package>/<package>_<version>.<ext>}
}

where \verb{.<ext>} is \code{.tar.gz} for source packages, or \code{.tgz} for binaries on
macOS and \code{.zip} for binaries on Windows. During \code{restore()}, \code{renv} will
search the cellar for a compatible package, and prefer installation with
that copy of the package if appropriate.
}

\section{Projects}{


In order to determine whether a package can safely be removed from the cache,
\code{renv} needs to know which projects are using packages from the cache. Since
packages may be symlinked from the cache, and symlinks are by nature a one-way
link, projects need to also report that they're using the \code{renv} cache.

To accomplish this, whenever \code{renv} is used with a project, it will record
itself as being used within a file located at:
\itemize{
\item \verb{$\{RENV_PATHS_ROOT\}/projects}
}

This file is list of projects currently using the \code{renv} cache. With this,
\code{renv} can crawl projects registered with \code{renv} and use that to determine if
any packages within the cache are no longer in use, and can be removed.
}

\examples{
# get the path to the project library
path <- renv::paths$library()
}
\keyword{datasets}
