% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{graph}
\alias{graph}
\title{Generate a Package Dependency Graph}
\usage{
graph(
  root = NULL,
  leaf = NULL,
  ...,
  suggests = FALSE,
  enhances = FALSE,
  resolver = NULL,
  renderer = c("DiagrammeR", "visNetwork"),
  attributes = list(),
  project = NULL
)
}
\arguments{
\item{root}{The top-most package dependencies of interest in the dependency graph.}

\item{leaf}{The bottom-most package dependencies of interest in the dependency graph.}

\item{...}{Unused arguments, reserved for future expansion. If any arguments
are matched to \code{...}, renv will signal an error.}

\item{suggests}{Should suggested packages be included within
the dependency graph?}

\item{enhances}{Should enhanced packages be included within
the dependency graph?}

\item{resolver}{An \R function accepting a package name, and returning the
contents of its \code{DESCRIPTION} file (as an \R \code{data.frame} or \code{list}).
When \code{NULL} (the default), an internal resolver is used.}

\item{renderer}{Which package should be used to render the resulting graph?}

\item{attributes}{An \R list of graphViz attributes, mapping node names to
attribute key-value pairs. For example, to ask graphViz to prefer orienting
the graph from left to right, you can use
\code{list(graph = c(rankdir = "LR"))}. See \url{https://graphviz.org/doc/info/attrs.html}
for a full list of the attributes supported by \code{graphViz}.}

\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}
}
\description{
Generate a package dependency graph.
}
\examples{

\dontrun{
# graph the relationship between devtools and rlang
graph(root = "devtools", leaf = "rlang")

# figure out why a project depends on 'askpass'
graph(leaf = "askpass")
}

}
\keyword{internal}
