% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vendor.R
\name{vendor}
\alias{vendor}
\title{Vendor renv in an R package}
\usage{
vendor(version = "main", project = getwd())
}
\arguments{
\item{version}{The version of renv to vendor. \code{renv} sources will be pulled
from GitHub, and so \code{version} should refer to either a commit hash or a
branch name.}

\item{project}{The project in which renv should be vendored.}
}
\description{
Calling \code{renv:::vendor()} will:
\itemize{
\item Compile a vendored copy of renv to \code{inst/vendor/renv.R},
\item Generate an renv auto-loader at \code{R/renv.R}.
}

Using this, projects can take a dependency on renv, and use renv
internals, in a CRAN-compliant way. After vendoring renv, you can
use renv APIs in your package via the embedded renv environment;
for example, you could call the \code{\link[=dependencies]{dependencies()}} function with:

\if{html}{\out{<div class="sourceCode">}}\preformatted{renv$dependencies()
}\if{html}{\out{</div>}}

Be aware that renv internals might change in future releases, so if you
need to rely on renv internal functions, we strongly recommend testing
your usages of these functions to avoid potential breakage.
}
\keyword{internal}
