% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snapshot.R
\name{snapshot}
\alias{snapshot}
\title{Record current state of the project library in the lockfile}
\usage{
snapshot(
  project = NULL,
  ...,
  library = NULL,
  lockfile = paths$lockfile(project = project),
  type = settings$snapshot.type(project = project),
  dev = FALSE,
  repos = getOption("repos"),
  packages = NULL,
  exclude = NULL,
  prompt = interactive(),
  update = FALSE,
  force = FALSE,
  reprex = FALSE
)
}
\arguments{
\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}

\item{...}{Unused arguments, reserved for future expansion. If any arguments
are matched to \code{...}, renv will signal an error.}

\item{library}{The \R libraries to snapshot. When \code{NULL}, the active \R
libraries (as reported by \code{.libPaths()}) are used.}

\item{lockfile}{The location where the generated lockfile should be written.
By default, the lockfile is written to a file called \code{renv.lock} in the
project directory. When \code{NULL}, the lockfile (as an \R object) is returned
directly instead.}

\item{type}{The type of snapshot to perform:
\itemize{
\item \code{"implicit"}, (the default), uses all packages captured by \code{\link[=dependencies]{dependencies()}}.
\item \code{"explicit"} uses packages recorded in \code{DESCRIPTION}.
\item \code{"all"} uses all packages in the project library.
\item \code{"custom"} uses a custom filter.
}

See \strong{Snapshot type} below for more details.}

\item{dev}{Boolean; include development dependencies? These packages are
typically required when developing the project, but not when running it
(i.e. you want them installed when humans are working on the project but
not when computers are deploying it).

Development dependencies include packages listed in the \code{Suggests} field
of a \code{DESCRIPTION} found in the project root, and roxygen2 or devtools if
their use is implied by other project metadata. They also include packages
used in \verb{~/.Rprofile} if \code{config$user.profile()} is \code{TRUE}.}

\item{repos}{The \R repositories to be recorded in the lockfile. Defaults
to the currently active package repositories, as retrieved by
\code{getOption("repos")}.}

\item{packages}{A vector of packages to be included in the lockfile. When
\code{NULL} (the default), all packages relevant for the type of snapshot being
performed will be included. When set, the \code{type} argument is ignored.
Recursive dependencies of the specified packages will be added to the
lockfile as well.}

\item{exclude}{A vector of packages to be explicitly excluded from the lockfile.
Note that transitive package dependencies will always be included, to avoid
potentially creating an incomplete / non-functional lockfile.}

\item{prompt}{Boolean; prompt the user before taking any action? For backwards
compatibility, \code{confirm} is accepted as an alias for \code{prompt}.}

\item{update}{Boolean; if the lockfile already exists, then attempt to update
that lockfile without removing any prior package records.}

\item{force}{Boolean; force generation of a lockfile even when pre-flight
validation checks have failed?}

\item{reprex}{Boolean; generate output appropriate for embedding the lockfile
as part of a \href{https://www.tidyverse.org/help/#reprex}{reprex}?}
}
\value{
The generated lockfile, as an \R object (invisibly). Note that
this function is normally called for its side effects.
}
\description{
Call \code{renv::snapshot()} to update a \link{lockfile} with the current state of
dependencies in the project library. The lockfile can be used to later
\link{restore} these dependencies as required.

It's also possible to call \code{renv::snapshot()} with a non-renv project,
in which case it will record the current state of dependencies in the
current library paths. This makes it possible to \link{restore} the current packages,
providing lightweight portability and reproducibility without isolation.

If you want to automatically snapshot after each change, you can
set \code{config$config$auto.snapshot(TRUE)}, see \code{?config} for more details.
}
\section{Snapshot types}{
Depending on how you prefer to manage dependencies, you might prefer
selecting a different snapshot mode. The modes available are as follows:

\describe{

\item{\code{"implicit"}}{
(The default) Capture only packages which appear to be used in your project,
as determined by \code{renv::dependencies()}. This ensures that only the packages
actually required by your project will enter the lockfile; the downside
if it might be slow if your project contains a large number of files.
If speed becomes an issue, you might consider using \code{.renvignore} files to
limit which files renv uses for dependency discovery, or switching to
explicit mode, as described next.
}

\item{\code{"explicit"}}{
Only capture packages which are explicitly listed in the project
\code{DESCRIPTION} file. This workflow is recommended for users who wish to
manage their project's \R package dependencies directly.
}

\item{\code{"all"}}{
Capture all packages within the active \R libraries in the lockfile.
This is the quickest and simplest method, but may lead to undesired
packages (e.g. development dependencies) entering the lockfile.
}

\item{\code{"custom"}}{
Like \code{"implicit"}, but use a custom user-defined filter instead. The filter
should be specified by the \R option \code{renv.snapshot.filter}, and should
either be a character vector naming a function (e.g. \code{"package::method"}),
or be a function itself. The function should only accept one argument (the
project directory), and should return a vector of package names to include
in the lockfile.
}

}

You can change the snapshot type for the current project with \code{\link[=settings]{settings()}}.
For example, the following code will switch to using \code{"explicit"} snapshots:

\if{html}{\out{<div class="sourceCode">}}\preformatted{renv::settings$snapshot.type("explicit")
}\if{html}{\out{</div>}}

When the \code{packages} argument is set, \code{type} is ignored, and instead only the
requested set of packages, and their recursive dependencies, will be written
to the lockfile.
}

\examples{

\dontrun{

# disable automatic snapshots
auto.snapshot <- getOption("renv.config.auto.snapshot")
options(renv.config.auto.snapshot = FALSE)

# initialize a new project (with an empty R library)
renv::init(bare = TRUE)

# install digest 0.6.19
renv::install("digest@0.6.19")

# save library state to lockfile
renv::snapshot()

# remove digest from library
renv::remove("digest")

# check library status
renv::status()

# restore lockfile, thereby reinstalling digest 0.6.19
renv::restore()

# restore automatic snapshots
options(renv.config.auto.snapshot = auto.snapshot)

}
}
\seealso{
More on handling package \code{\link[=dependencies]{dependencies()}}

Other reproducibility: 
\code{\link{lockfiles}},
\code{\link{restore}()}
}
\concept{reproducibility}
