% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copyToFrom.R
\name{replyr_drop_table_name}
\alias{replyr_drop_table_name}
\title{Drop a table from a source}
\usage{
replyr_drop_table_name(dest, name)
}
\arguments{
\item{dest}{remote data source}

\item{name}{name of table to drop}
}
\value{
logical TRUE if table was present
}
\description{
Drop a table from a source
}
\examples{

if (requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- dplyr::src_sqlite(":memory:", create = TRUE)
  d <- replyr_copy_to(my_db, data.frame(x=c(1,2)), 'd')
  print(d)
  replyr_list_tables(my_db)
  replyr_drop_table_name(my_db, 'd')
  replyr_list_tables(my_db)
}

}
