% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joinController.R
\name{makeJoinDiagramSpec}
\alias{makeJoinDiagramSpec}
\title{Build a drawable specification of the join diagram}
\usage{
makeJoinDiagramSpec(columnJoinPlan, ..., groupByKeys = TRUE,
  graphOpts = NULL)
}
\arguments{
\item{columnJoinPlan}{join plan}

\item{...}{force later arguments to bind by name}

\item{groupByKeys}{logical if true build key-equivalent sub-graphs}

\item{graphOpts}{options for graphViz}
}
\value{
grViz diagram spec
}
\description{
Please see \code{vignette('DependencySorting', package = 'replyr')} and \code{vignette('joinController', package= 'replyr')} for more details.
}
\examples{


if (requireNamespace("RSQLite", quietly = TRUE)) {
  # note: employeeanddate is likely built as a cross-product
  #       join of an employee table and set of dates of interest
  #       before getting to the join controller step.  We call
  #       such a table "row control" or "experimental design."
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  RSQLite::initExtension(my_db)
  tDesc <- replyr:::example_employeeAndDate(my_db)
  # fix order by hand, please see replyr::topoSortTables for
  # how to automate this.
  ord <- match(c('employeeanddate', 'orgtable', 'activity', 'revenue'),
               tDesc$tableName)
  tDesc <- tDesc[ord, , drop=FALSE]
  columnJoinPlan <- buildJoinPlan(tDesc, check= FALSE)
  # unify keys
  columnJoinPlan$resultColumn[columnJoinPlan$resultColumn=='id'] <- 'eid'
  # look at plan defects
  print(paste('problems:',
              inspectDescrAndJoinPlan(tDesc, columnJoinPlan)))
  diagramSpec <- makeJoinDiagramSpec(columnJoinPlan)
  # to render as JavaScript:
  #   DiagrammeR::grViz(diagramSpec)
  # or as a PNG:
  #   renderJoinDiagram(diagramSpec)
  #
  DBI::dbDisconnect(my_db)
  my_db <- NULL
}

}
\seealso{
\code{\link{tableDescription}}, \code{\link{buildJoinPlan}}, \code{\link{renderJoinDiagram}}, \code{\link{executeLeftJoinPlan}}
}
