% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/repoS3.R
\name{repo_tags}
\alias{repo_tags}
\title{List all tags}
\usage{
repo_tags(repo)
}
\arguments{
\item{repo}{An object of class repo.}
}
\value{
Character vector of unique tags defined in the repo.
}
\description{
Shows list of all unique tags associated with any item in the
repository.
}
\examples{
repo_path <- file.path(tempdir(), "example_repo")
repo <- repo_open(repo_path, TRUE)

## Putting two items with a few tags
repo$put(1, "item1", "Sample item 1",
    c("repo_tags", "tag1"), replace=TRUE)
repo$put(2, "item2", "Sample item 2",
    c("repo_tags", "tag2"), replace=TRUE)

## Looking up tags
repo$tags()

## wiping temporary repo
unlink(repo_path, TRUE)
}
\seealso{
repo_put
}

