% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repoS3.R
\name{repo_info}
\alias{repo_info}
\title{Provides detailed information about an item.}
\usage{
repo_info(rp, name = NULL, tags = NULL)
}
\arguments{
\item{rp}{An object of class repo.}

\item{name}{Item name (or list of names). If both name and tags are NULL, information
about the whole repo will be provided.}

\item{tags}{List of tags: info will run on all items matching the tag list.}
}
\value{
Used for side effects.
}
\description{
Provides detailed information about an item.
}
\examples{
rp_path <- file.path(tempdir(), "example_repo")
rp <- repo_open(rp_path, TRUE)
rp$put(1, "item1", "Sample item 1", "info")
rp$info("item1")

## wiping temporary repo
unlink(rp_path, TRUE)
}

