% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_random.R
\name{report_random}
\alias{report_random}
\title{Report random effects and factors}
\usage{
report_random(x, ...)
}
\arguments{
\item{x}{The R object that you want to report (see list of of supported
objects above).}

\item{...}{Arguments passed to or from other methods.}
}
\value{
An object of class \code{\link{report_random}}.
}
\description{
Reports random effects of mixed models (see list of supported objects in
\code{\link{report}}).
}
\examples{
library(report)

# Mixed models
if (require("lme4")) {
  model <- lme4::lmer(Sepal.Length ~ Petal.Length + (1 | Species), data = iris)
  r <- report_random(model)
  r
  summary(r)
}
\donttest{
# Bayesian models
if (require("rstanarm")) {
  model <- stan_lmer(mpg ~ disp + (1 | cyl), data = mtcars, refresh = 0, iter = 1000)
  r <- report_random(model)
  r
  summary(r)
}
}
\dontrun{
if (require("brms")) {
  model <- brm(mpg ~ disp + (1 | cyl), data = mtcars, refresh = 0, iter = 1000)
  r <- report_random(model)
  r
  summary(r)
}
}
}
