% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_spec.r
\encoding{UTF-8}
\name{options_fixed}
\alias{options_fixed}
\title{Set options for a fixed-width report}
\usage{
options_fixed(
  x,
  editor = NULL,
  cpuom = NULL,
  lpuom = NULL,
  min_margin = NULL,
  blank_margins = FALSE,
  font_size = NULL,
  line_size = NULL,
  line_count = NULL,
  uchar = "¯"
)
}
\arguments{
\item{x}{The report spec.}

\item{editor}{The expected text editor to use for printing text reports.
Assigning this parameter will set the \code{cpuom} and \code{lpuom} 
parameters appropriately for the text editor.  Valid values are 'notepad',
'word', 'wordpad', 'notepad++', and 'editplus'.  If the editor parameter 
is used, any settings for \code{cpuom} and \code{lpuom} will be 
ignored. It is not necessary to set this parameter for RTF and PDF reports.}

\item{cpuom}{Characters per unit of measure of printed text.
If units is inches, the default is 12.  If units is centimeters (cm), the 
default is 4.687.  This value will be used to 
determine how many characters can fit on a line.}

\item{lpuom}{Lines per unit of measure of the printed text. Default for 
inches is 6. The default for centimeters (cm) is 2.55.  This value 
will be used to determine the number of lines that can fit on a page.}

\item{min_margin}{The editor minimum margin.  This parameter normally
defaults to 0, but may be set for some types of editors.}

\item{blank_margins}{When this option is TRUE, \strong{reporter} will use blank 
spaces and blank rows to create left and top margins, rather than rely 
on the editor to set margins.  When used, editor margins
should be set to zero.  Valid values are TRUE and FALSE. Default is
FALSE.  This option is only valid for \code{output_type = 'TXT'}.}

\item{font_size}{The size of the font in points.  Default is 10pt.  This
option is only valid for output types RTF and PDF.  Valid values are 8, 10, 
and 12.}

\item{line_size}{The number of characters that will fit on a line.  Normally,
the \code{line_size} is calculated based on the page size, font size, and cpuom.
You can override the calculated value by setting the \code{line_size}
directly.}

\item{line_count}{The number of lines that will fit on page.  Normally,
the \code{line_count} is calculated based on the page size, font size, and lpuom.
You can override the calculated value by setting the \code{line_count}
directly.}

\item{uchar}{The character to use for underlines on the table 
header and spanning headers.  Default is a Unicode macron character #U00AF.
You may use a dash or underscore if your editor does not support
Unicode.  The \code{uchar} is forced to a dash for PDF output, 
as the LaTeX converter does not support the macron character.}
}
\value{
The updated report spec.
}
\description{
This function sets the options for a report  
with a fixed width font.
}
\details{
The \code{options_fixed} function sets options for reports 
with a fixed-width, monospace font.  These reports are based off a 
text report, but may be output as type "RTF" or "PDF".
}
\section{Text Reports}{

The \code{options_fixed} function sets
the characters per 
unit of measure (\code{cpuom}) and lines per unit of measure
(\code{lpuom}) settings for the report.  These settings determine how 
many characters and lines will fit within one unit of measure (uom), as 
specified on the \code{\link{create_report}} function.  These settings are
important to ensure the report content stays within the available page size 
and margins.  Because every editor allows a different number of 
characters and lines on a page, these settings must be adjusted depending
on the editor.  

The \code{options_fixed} function provides a shortcut 
\code{editor} parameter
to directly specify a popular editor.  If this parameter is specified, the
function will set the characters per unit of measure and lines per
unit of measure for you.  If the editor is not available in the 
\code{editor} parameter selections, for best results, you should 
set the \code{cpuom} and 
\code{lpuom} parameters manually.  To determine your \code{cpuom}
and \code{lpuom}, see the help for \code{\link{write_registration_file}}.

Alternatively, using the \code{options_fixed} function, 
you may set the \code{line_size} and \code{line_count} directly.  Note that
the \code{line_size} and \code{line_count} may be different for different
output types and editors. 

The \code{min_margin} parameter is used to set the minimum margin allowed
by the editor.  This value will be subtracted from the margin settings 
when the \code{blank_margins} option is used. It is useful for 
editors that do not calculate margins from the edge of the page.

As some editors do not support Unicode characters, it may be necessary 
to change the character used for the header and spanning header underlines.
The default character is a Unicode #U00AF macron.  The macron is sometimes
referred to as an "overline", since it is located at the top of the 
character area.  If your editor does not support Unicode, the macron
will not be displayed properly.  In this case, change the underline character
to a dash ("-") or an underscore ("_") using the \code{uchar} parameter.
}

\section{RTF and PDF Reports}{

For RTF and PDF reports, most of the parameters on the \code{options_fixed}
function do not apply.  For RTF and PDF reports, these parameters will
be set automatically, and cannot be changed.  

Some of the \code{options_fixed} function apply only to RTF and PDF.
In particular, the \code{font_size} parameter applies only to RTF and PDF
reports.  Valid font size options are 8, 10, and 12.
}

\examples{
library(reporter)
library(magrittr)

# Create a temporary file
tmp <- file.path(tempdir(), "bod.txt")

# Define table
tbl <- create_table(BOD, width = 2.5) \%>\% 
  titles("Table 3.6", "BOD* Sample Report") \%>\% 
  define(Time, format = "Day \%s", align = "left") \%>\% 
  define(demand, format = "\%2.1f mg/l", label = "Demand") \%>\% 
  footnotes("* Biochemical Oxygen Demand")
       
# Define report #1 - No blank margins
rpt <- create_report(tmp, orientation="portrait") \%>\%
  add_content(tbl, align = "left") 

# Write the report
write_report(rpt)

# Write report to console
writeLines(readLines(tmp, encoding = "UTF-8"))

#           Table 3.6
#       BOD* Sample Report
# 
# Time                  Demand
# ----------------------------
# Day 1               8.3 mg/l
# Day 2              10.3 mg/l
# Day 3              19.0 mg/l
# Day 4              16.0 mg/l
# Day 5              15.6 mg/l
# Day 7              19.8 mg/l
# 
# * Biochemical Oxygen Demand


# Define report #2 - blank margins
rpt <- create_report(tmp, orientation="portrait") \%>\%
  options_fixed(blank_margins = TRUE) \%>\% 
  set_margins(top = .5, left = 1) \%>\% 
  add_content(tbl, align = "left") 

# Write the report
write_report(rpt)

# Write report to console
writeLines(readLines(tmp, encoding = "UTF-8"))

# 
# 
# 
#                       Table 3.6
#                   BOD* Sample Report
# 
#              Time                  Demand
#              ----------------------------
#              Day 1               8.3 mg/l
#              Day 2              10.3 mg/l
#              Day 3              19.0 mg/l
#              Day 4              16.0 mg/l
#              Day 5              15.6 mg/l
#              Day 7              19.8 mg/l
# 
#              * Biochemical Oxygen Demand
}
\seealso{
\code{\link{create_report}} to create a report and set the unit
of measure, \code{\link{write_registration_file}} to determine the 
characters and lines per unit of measure manually.

Other report: 
\code{\link{add_content}()},
\code{\link{create_report}()},
\code{\link{footnotes}()},
\code{\link{page_by}()},
\code{\link{page_footer}()},
\code{\link{page_header}()},
\code{\link{print.report_spec}()},
\code{\link{set_margins}()},
\code{\link{title_header}()},
\code{\link{titles}()},
\code{\link{write_report}()}
}
\concept{report}
