% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPSimulation.R
\name{RandomizedDesignEffectSizes}
\alias{RandomizedDesignEffectSizes}
\title{RandomizedDesignEffectSizes}
\usage{
RandomizedDesignEffectSizes(m1, std1, m2, std2, type = "n")
}
\arguments{
\item{m1}{The theoretical mean for the control group}

\item{std1}{The theoretical variance for the control group}

\item{m2}{The theoretical mean for the treatment group}

\item{std2}{The theoretical variance for the treatment group}

\item{type}{String identifying the distribution, "n" for normal, "ln" for lognormal, "lap" for Laplace, "g" for Gamma}
}
\value{
dataframe containing the expected values of the unstandardized mean difference effect size, the pooled witjin group variance, the standardized mean difference effect size and the point bi-serial correlation.
}
\description{
This function creates the theoretical effect sizes for random samples from one of four different distributions for specified parameter values for the diftribution specified by the type parameter. It assumes there are two samples, one corresponding to a control group and the other to the treatment group. It returns the theoretical effect sizes for a fully randomized experiment.
}
\examples{
RandomizedDesignEffectSizes(m1=0, std1=1, m2=1, std2=3, type = "n")
# A tibble: 1 x 4
#      ES   Var StdES  rPBS
#   <dbl> <dbl> <dbl> <dbl>
# 1     1     5 0.447 0.218
RandomizedDesignEffectSizes(m1=0, std1=1, m2=1, std2=3, type = "l")
# A tibble: 1 x 4
#     ES        Var  StdES    rPBS
# <dbl>      <dbl>  <dbl>   <dbl>
#1  243. 242552663. 0.0156 0.00780
 RandomizedDesignEffectSizes(m1=0, std1=1, m2=0.266, std2=1, type = "l")
# A tibble: 1 x 4
#     ES   Var StdES   rPBS
#  <dbl> <dbl> <dbl>  <dbl>
#1 0.502  6.31 0.200 0.0995
}
\author{
Barbara Kitchenham and Lech Madeyski
}
