% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPSimulation.R
\name{simulateRandomizedDesignEffectSizes}
\alias{simulateRandomizedDesignEffectSizes}
\title{simulateRandomizedDesignEffectSizes}
\usage{
simulateRandomizedDesignEffectSizes(mean, sd, diff, N, type = "n", StdAdj = 0)
}
\arguments{
\item{mean}{The mean used for one of the treatment groups}

\item{sd}{The spread used for both treatment groups. It mus be a real value greater than 0.}

\item{diff}{This is added to the parameter mean, to define the mean of the other treatment group. It can be a real value avd can take the value zero.}

\item{N}{this is the number of observations in each group. It must be an integer greater than 3.}

\item{type}{this specifies the underlying distribution used to generate the data. it takes the values "n" for a normal distribution, "l" for lognormal distribution,"g" for a gamma distribution, "lap" for a Laplace distribution.}

\item{StdAdj}{this specifes the extent of variance instability introduced by the treatment.}
}
\value{
data frame incl. the non-parametric and parametric effect sizes and whether the effect sizes are significant at the 0.05 level.
}
\description{
This simulates one of four distributions, and finds the values of ktau, phat and Cliffs d and their variances. It assumes equal group sizes. It returns values of the effect sizes and their variance for a simulated randomized experiment with two treatments.  It returns whether to not each non-parametric effect size was significant. It also returns the parametric (unstandardized and unstandardized) Effect Size and the whether the t-test was signficiant.
}
\examples{
set.seed(123)
simulateRandomizedDesignEffectSizes(mean=0,sd=1,diff=0.8,N=10,type="n",StdAdj=0)
# A tibble: 1 x 15
# phat varphat dfphat sigphat     d   vard sigd    cor varcor sigCVt ttestp    ES Variance StdES
# MedDiff
# <dbl>   <dbl>  <dbl> <lgl>   <dbl>  <dbl> <lgl> <dbl>  <dbl> <lgl>   <dbl> <dbl>    <dbl> <dbl>
# <dbl>
#1  0.75  0.0152   17.5 FALSE     0.5 0.0624 FALSE 0.263 0.0175 FALSE  0.0507 0.934  0.994 0.937
# 1.26
set.seed(123)
simulateRandomizedDesignEffectSizes(mean=0,sd=1,diff=0.8,N=10,type="l",StdAdj=0)
# A tibble: 1 x 19
#   phat varphat dfphat sigphat     d   vard sigd    cor varcor sigCVt ttestp    ES Variance
# StdES MedDiff transttest
#  <dbl>   <dbl>  <dbl> <lgl>   <dbl>  <dbl> <lgl> <dbl>  <dbl> <lgl>   <dbl> <dbl>    <dbl>
# <dbl>   <dbl>      <dbl>
#1  0.75  0.0152   17.5 FALSE     0.5 0.0624 FALSE 0.263 0.0175 FALSE  0.0958  2.41     9.01
# 0.802    2.32     0.0507
# … with 3 more variables: EStrans <dbl>, StdEStrans <dbl>, VarTrans <dbl>
}
\author{
Barbara Kitchenham and Lech Madeyski
}
