% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPSimulation.R
\name{NP2GMetaAnalysisSimulation}
\alias{NP2GMetaAnalysisSimulation}
\title{NP2GMetaAnalysisSimulation}
\usage{
NP2GMetaAnalysisSimulation(
  mean,
  sd,
  diff,
  GroupSize,
  Exp = 5,
  type = "n",
  StdAdj = 0,
  alpha = 0.05,
  seed = 123,
  StdExp = 0,
  MAMethod,
  returnES = FALSE,
  AlwaysTwoSidedTests = FALSE
)
}
\arguments{
\item{mean}{the value used for the mean of control group in the simulated data. It can be any real number including zero.}

\item{sd}{the value used for the spread of the control group and the spread of the treatment group in the simulated data. The value must be a real value greater than 0.}

\item{diff}{mean+diff is the value used for the mean of the treatment group. It can be zero.}

\item{GroupSize}{is the size of each of the 2 groups comprising one experiment. Groupsize should be an integer of 4 or more}

\item{Exp}{is the number of experiments being simulated. Exp should be an integer of 2 or more. It defaults to 5.}

\item{type}{specifies the distribution being simulated. The permitted values are 'n' for the normal distribution,  'l' for the lognormal distribution, 'g' for the gamma distribution and 'lap' for the Laplace distribution. The parameter defaults to 'n'.}

\item{StdAdj}{specifies a level used to adjust the treatment variance. It allows heterogeneity to be modelled. It defaults to zero meaning no variance heterogeneity is introduced.}

\item{alpha}{the Type 1 error rate level use for statistical tests (default 0.05).}

\item{seed}{specifies the seed to be used to initiate the simulation, so the simulation is repeatable. It defaults to 123.}

\item{StdExp}{if non-zero it simulates a random effect between experiments
in the same family (default 0).}

\item{MAMethod}{the meta-analysis method needed for the call to the metafor package rma algorithm}

\item{returnES}{Determines the format of the output. It defaults to FALSE which causes the function to output the meta-analysis results for the family of experiments. If set to TRUE it returns the effect sizes for each experiment.}

\item{AlwaysTwoSidedTests}{If FALSE the function performs one-sided tests if diff!=0, and two-sided tests if diff=0. If set to TRUE the function always does two-sided tests (default: AlwaysTwoSidedTests=FALSE).}
}
\value{
Depending on the value of the returnES parameter, the function either returns the effect sizes for each experiment or the aggregated results for the family
}
\description{
This function simulates data from a family of experiments. The parameter Exp determines the number of experiments in the family. The function simulates data from one of four distributions and uses the data to construct two of groups of equal size (GroupSize). The distribution for one  of the groups corresponds to the control and is based on the given mean and spread, the distribution for the other group corresponds to the treatment group and  is based on the mean+diff and the spread plus any variance adjustment requested (determined by the parameter StdAdj). The data from each experiment is analysed separately to estimate three non-parametric effect sizes: the Cliff's d and the probability of superiority referred to as phat and their variances. Parametric effect sizes Cohen's d (also known as the standardized means difference, SMD) and the small sample size adjusted standardized mean difference g are also calculated together with their variances. The effect sizes are then meta-analysed using various methods: the simple average of the effect size and the variance weighted averages (using the exact and approximate normal variance and the weighted and unweighted standardized mean difference). The function uses the metafor package for formal meta-analysis, and the specific method of formal meta-analysis used is determined by the MAMethod. All tests of significance are done at the 0.05 level. If the parameter returnES is TRUE, the function returns the effect sizes for each experiment in the family, otherwise it returns the meta-analysis results.
}
\examples{
as.data.frame(
  NP2GMetaAnalysisSimulation(
    mean = 0, sd = 1, diff = 0.5, GroupSize = 10, Exp = 5, type = "n",
    StdAdj = 0, alpha = 0.05, seed = 457, StdExp = 1, MAMethod = "PM",
    returnES = FALSE))
#  NumExp GroupSize AveCliffd AveCliffdvar AveCliffdsig Avephat  Avephatvar..
#      5        10     0.252   0.01499003         TRUE   0.626 0.003645333..
as.data.frame(
  NP2GMetaAnalysisSimulation(
    mean=0, sd=1, diff=0.5, GroupSize=10, Exp=5, type='n', StdAdj=0,
    alpha=0.05, seed=457, StdExp=1, MAMethod='PM', returnES=TRUE))
#    MeanExp   VarExp     StdMD       df      tval t.sig Cliffd  Cliffdvar...
as.data.frame(
  NP2GMetaAnalysisSimulation(
    mean=0, sd=1, diff=0.724, GroupSize=10, Exp=5, type='l', StdAdj=0,
    alpha=0.05, seed=123, StdExp=1, MAMethod='PM', returnES=FALSE))
#  NumExp GroupSize AveCliffd AveCliffdvar AveCliffdsig Avephat  Avephatvar..
#1      5        10     0.344   0.01288023         TRUE   0.672 0.003118222..
}
\author{
Barbara Kitchenham and Lech Madeyski
}
