% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPSimulation.R
\name{calculate4GMdMRE}
\alias{calculate4GMdMRE}
\title{calculate4GMdMRE}
\usage{
calculate4GMdMRE(
  mean = 0,
  sd = 1,
  N = 10,
  reps = 10,
  diff = c(0.2, 0.5, 0.8),
  type = "n",
  seed = 123,
  StdAdj = 0,
  Blockmean = 0.5,
  AlwaysTwoSidedTests = FALSE,
  LargeSampleSize = 2500000
)
}
\arguments{
\item{mean}{The mean (or rate for gamma data) of the baseline distribution}

\item{sd}{The standard deviation or shape of the baseline distribution}

\item{N}{The number of obervations per group}

\item{reps}{The number of replications (i.e. two-group datasets) to be simulated}

\item{diff}{A list identifying the mean group differences being assessed}

\item{type}{A string parameter defining the distribution being simulated i.e. 'n' for normal data, 'l' for log-normal data, 'g' for gamma data and 'lap' for LaPlace data.}

\item{seed}{A starting value for the simulations}

\item{StdAdj}{A numerical parameter that can be used to add additional variance for normal, lognormal and Laplce data and to change the shape parameter for gamma data.}

\item{Blockmean}{A numerical parameter used to introduce a fixed Block effect}

\item{AlwaysTwoSidedTests}{A boolean variable. If TRUE the simulations always used two-sided tests otherwise the simulations use one-sided tests.}

\item{LargeSampleSize}{Size of the large sample (default 2500000) in each of
the four groups used to obtain expected values of the non-parametric effect
sizes for four group experiments (the expected value of the standardized
mean difference is always known)
return Tibble identifying the accuracy i.e. MdMRE of three effect sizes Cliff's d, PHat, and StdMD estimates found in each simulation, the variance of each of effect sizes, the mean of the observed values, the expected values of the effect sizes based on a single large sample and the power of each effect size based on the proportion of samples for which the effect sizes were significant.
example
as.data.frame(calculate4GMdMRE(mean=0,sd=1,N=10,reps=100,diff=c(0.2,0.5,0.8),type='n',seed=123,StdAdj = 0,Blockmean = 0.5,AlwaysTwoSidedTests=FALSE,LargeSampleSize=5000))}
}
\description{
The function uses simulation to assess the accuracy and power of parametric and non-parametric effect sizes for four group randomized block ddesigns and four different distributions.
}
\author{
Barbara Kitchenham and Lech Madeyski
}
