% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache-helpers.R
\name{.prepareFileBackedRaster}
\alias{.prepareFileBackedRaster}
\title{Copy the file-backing of a file-backed Raster* object}
\usage{
.prepareFileBackedRaster(obj, repoDir = NULL)
}
\arguments{
\item{obj}{The raster object to save to the repository.}

\item{repoDir}{Character denoting an existing directory in which an artifact will be saved.}

\item{...}{passed to \code{archivist::saveToRepo}}
}
\value{
A raster object and its newly located file backing.
        Note that if this is a legitimate archivist repository, the new location
        will be a subdirectory called \file{rasters/} of \file{repoDir/}.
        If this is not a repository, the new location will be within \code{repoDir}.
}
\description{
Rasters are sometimes file-based, so the normal save and copy and assign
mechanisms in R don't work for saving, copying and assigning.
This function creates an explicit file copy of the file that is backing the raster,
and changes the pointer (i.e., \code{filename(object)}) so that it is pointing
to the new file.
}
\examples{
library(raster)
archivist::createLocalRepo(tempdir())

r <- raster(extent(0,10,0,10), vals = 1:100)

# write to disk manually -- will be in tempdir()
r <- writeRaster(r, file = tempfile())

# copy it to the cache repository
r <- .prepareFileBackedRaster(r, tempdir())

r # now in "rasters" subfolder of tempdir()


}
\author{
Eliot McIntire
}
